/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;

public class CreateResourceGroupTask
extends AzureTask<ResourceGroup> {
    private final String subscriptionId;
    private final String resourceGroupName;
    private final Region region;

    public CreateResourceGroupTask(String subscriptionId, String resourceGroupName, Region region) {
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.region = region;
    }

    @Override
    public ResourceGroup doExecute() {
        ResourceGroup rg = (ResourceGroup)Azure.az(AzureResources.class).groups(this.subscriptionId).getOrDraft(this.resourceGroupName, this.resourceGroupName);
        if (rg.isDraftForCreating()) {
            ResourceGroupDraft draft = (ResourceGroupDraft)rg;
            draft.setRegion(this.region);
            draft.createIfNotExist();
        }
        return rg;
    }
}

