/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.models.GenericResources;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class GenericResourceModule
extends AbstractAzResourceModule<GenericResource, ResourceGroup, HasId> {
    public static final String NAME = "genericResources";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public GenericResourceModule(@Nonnull ResourceGroup parent) {
        super(NAME, parent);
    }

    @Nullable
    public GenericResources getClient() {
        return Optional.ofNullable((ResourceManager)((ResourcesServiceSubscription)((ResourceGroup)this.parent).getParent()).getRemote(new boolean[0])).map(ResourceManager::genericResources).orElse(null);
    }

    @Override
    @Nonnull
    @AzureOperation(name="resource.load_resources_in_azure.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.REQUEST)
    protected Stream<HasId> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            GenericResources resources = Objects.requireNonNull(this.getClient());
            Stream<HasId> stream = resources.listByResourceGroup(((ResourceGroup)this.parent).getName()).stream().filter(r -> Objects.isNull(ResourceId.fromString((String)r.id()).parent())).map(r -> r);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceId, @Nullable String resourceGroup) {
        return resourceId;
    }

    @Override
    @Nonnull
    protected GenericResource newResource(@Nonnull HasId r) {
        return new GenericResource(r, this);
    }

    @Override
    @Nonnull
    protected GenericResource newResource(@Nonnull String resourceId, @Nullable String resourceGroupName) {
        return new GenericResource(resourceId, this);
    }

    @Override
    @Nonnull
    public GenericResource newResource(@Nonnull AbstractAzResource<?, ?, ?> concrete) {
        return new GenericResource(concrete, this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Generic resource";
    }

    static {
        GenericResourceModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GenericResourceModule.java", GenericResourceModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.resource.GenericResourceModule", "", "", "", "java.util.stream.Stream"), 41);
    }
}

