/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.proxy;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ProxyManager {
    private static final String PROPERTY_USE_SYSTEM_PROXY = "java.net.useSystemProxies";
    private static final int MAX_PORT_NUMBER = 65535;
    private static final boolean isSystemProxyUnset = StringUtils.isBlank((CharSequence)System.getProperty("java.net.useSystemProxies"));
    private Proxy proxy;

    public static ProxyManager getInstance() {
        return ProxyManagerHolder.INSTANCE;
    }

    public String getHttpProxyHost() {
        if (Objects.nonNull(this.proxy) && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            return address.getHostString();
        }
        return null;
    }

    public int getHttpProxyPort() {
        if (Objects.nonNull(this.proxy) && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            return address.getPort();
        }
        return 0;
    }

    public void configure(@Nonnull String httpProxyHost, @Nonnull Integer httpProxyPort) {
        Preconditions.checkNotNull((Object)httpProxyHost, (Object)"httpProxyHost must not be null.");
        Preconditions.checkNotNull((Object)httpProxyHost, (Object)"httpProxyPort must not be null.");
        if (httpProxyPort <= 0 || httpProxyPort > 65535) {
            throw new IllegalArgumentException(String.format("Invalid range of httpProxyPort: '%s', it should be a number between %d and %d", httpProxyPort, 1, 65535));
        }
        if (this.forceUseSystemProxy()) {
            throw new IllegalArgumentException("Cannot set the proxy second time when user has specified the proxy through vm arguments: -Djava.net.useSystemProxies=true.");
        }
        this.proxy = ProxyManager.createHttpProxy(httpProxyHost, httpProxyPort);
        this.replaceDefaultProxySelector();
    }

    public void init() {
        if (isSystemProxyUnset) {
            System.setProperty(PROPERTY_USE_SYSTEM_PROXY, "true");
        }
        this.proxy = ProxyManager.getSystemProxyInner();
        if (isSystemProxyUnset) {
            System.clearProperty(PROPERTY_USE_SYSTEM_PROXY);
        }
    }

    public boolean forceUseSystemProxy() {
        return !isSystemProxyUnset && this.proxy != null;
    }

    private void replaceDefaultProxySelector() {
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(ProxyManager.this.proxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    private static Proxy createHttpProxy(String httpProxyHost, Integer httpProxyPort) {
        return StringUtils.isNotBlank((CharSequence)httpProxyHost) ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, (int)httpProxyPort)) : null;
    }

    private static Proxy getSystemProxyInner() {
        URI uri = new URI("https://login.microsoft.com");
        for (Proxy proxy : ProxySelector.getDefault().select(uri)) {
            if (!(proxy.address() instanceof InetSocketAddress)) continue;
            return proxy;
        }
        return null;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private static class ProxyManagerHolder {
        private static final ProxyManager INSTANCE = new ProxyManager();

        private ProxyManagerHolder() {
        }
    }
}

