/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureOperationContext {
    private static final Logger log = Logger.getLogger(AzureOperationContext.class.getName());
    private static final ThreadLocal<AzureOperationContext> context = new ThreadLocal();
    protected long threadId = -1L;
    @Nullable
    protected IAzureOperation<?> operation;
    @Nullable
    protected AzureOperationContext parent;

    private AzureOperationContext(@Nullable AzureOperationContext parent) {
        this.setParent(parent);
    }

    private synchronized void setParent(@Nullable AzureOperationContext parent) {
        if (!Objects.equals(this.parent, parent)) {
            this.parent = parent;
            this.operation = Optional.ofNullable(parent).map(p -> p.operation).orElse(null);
        }
    }

    @Nonnull
    public static AzureOperationContext current() {
        AzureOperationContext ctxNode = context.get();
        if (Objects.isNull(ctxNode)) {
            ctxNode = new AzureOperationContext(null);
            context.set(ctxNode);
        }
        return ctxNode;
    }

    @Nullable
    public IAzureOperation<?> currentOperation() {
        return this.operation;
    }

    public synchronized void pushOperation(IAzureOperation<?> operation) {
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            log.fine(String.format("orphan context[%s] is setup", this));
        }
        operation.setParent(this.operation);
        this.operation = operation;
    }

    @Nullable
    public synchronized IAzureOperation<?> popOperation() {
        IAzureOperation<?> popped = this.operation;
        assert (popped != null) : "popped operation is null";
        this.operation = popped.getParent();
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            context.remove();
            log.fine(String.format("orphan context[%s] is disposed", this));
        }
        return popped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) {
        try {
            this.setup();
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
            if (!(rootCause instanceof InterruptedIOException) && !(rootCause instanceof InterruptedException)) {
                AzureMessager.getMessager().error(throwable);
            }
        }
        finally {
            this.dispose();
        }
    }

    @Nonnull
    public AzureOperationContext derive() {
        long threadId = Thread.currentThread().getId();
        AzureOperationContext current = AzureOperationContext.current();
        assert (this == current) : String.format("[threadId:%s] deriving context from context[%s] in context[%s].", threadId, this, current);
        this.threadId = this.threadId > 0L ? this.threadId : threadId;
        return new AzureOperationContext(this);
    }

    private synchronized void setup() {
        AzureOperationContext current = AzureOperationContext.current();
        long threadId = Thread.currentThread().getId();
        assert (current.threadId == -1L || current.threadId == threadId) : String.format("[threadId:%s] illegal thread context[%s]", threadId, current);
        this.threadId = threadId;
        if (current.threadId != -1L) {
            this.setParent(current);
        }
        context.set(this);
    }

    private synchronized void dispose() {
        AzureOperationContext current = AzureOperationContext.current();
        long threadId = Thread.currentThread().getId();
        assert (this == current && this.threadId == threadId) : String.format("[threadId:%s] disposing context[%s] in context[%s].", threadId, this, current);
        if (this.parent == null || this.threadId != this.parent.threadId) {
            context.remove();
        } else {
            context.set(this.parent);
        }
    }

    public String getId() {
        return Utils.getId(this);
    }

    public String toString() {
        String id = this.getId();
        String prId = Optional.ofNullable(this.parent).map(AzureOperationContext::getId).orElse("/");
        return String.format("{id: %s, threadId:%s, parent:%s}", id, this.threadId, prId);
    }

    @Nullable
    public AzureOperationContext getParent() {
        return this.parent;
    }
}

