/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractAzService<T extends AbstractAzResourceManager<T, R>, R>
extends AbstractAzResourceModule<T, AzResource.None, R>
implements AzService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AbstractAzService(@Nonnull String name) {
        super(name, AzResource.NONE);
        AzureEventBus.on("account.logout.account", new AzureEventBus.EventListener(e -> this.clear()));
        AzureEventBus.on("account.subscription_changed.account", new AzureEventBus.EventListener(e -> this.refresh()));
    }

    @Override
    @Nullable
    public T get(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (T)((AbstractAzResourceManager)this.get(id.subscriptionId(), id.resourceGroupName()));
    }

    @Override
    @Nonnull
    public String getFullResourceType() {
        return this.getName();
    }

    @Preload
    @AzureOperation(name="resource.preload", type=AzureOperation.Type.ACTION)
    private static void preload() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getActionContext().setProperty("preloading", String.valueOf(true));
            List<AbstractAzService> services = Azure.getServices(AbstractAzService.class);
            ((Stream)services.stream().parallel()).flatMap(s -> s.list().stream()).flatMap(m -> ((AbstractAzResourceManager)m).getSubModules().stream()).forEach(m -> ((AzResourceModule)m).list());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public T forSubscription(@Nonnull String subscriptionId) {
        return (T)Objects.requireNonNull((AbstractAzResourceManager)this.get(subscriptionId, null));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.list().forEach(AbstractAzResource::refresh);
    }

    @Override
    @Nonnull
    @AzureOperation(name="resource.list_resources.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected Stream<R> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Stream<Object> stream = ((Stream)Azure.az(IAzureAccount.class).account().getSelectedSubscriptions().stream().parallel()).map(Subscription::getId).map(i -> this.loadResourceFromAzure((String)i, null));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceName, String resourceGroup) {
        String rg = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, "${rg}"});
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/%s", resourceName, rg, this.getName());
    }

    @Nullable
    public <E> E getById(@Nonnull String id) {
        return this.doGetById(id);
    }

    @Nullable
    protected <E> E doGetById(@Nonnull String id) {
        ResourceId resourceId;
        String resourceGroup = resourceId.resourceGroupName();
        AbstractAzResource resource = Objects.requireNonNull((AbstractAzResourceManager)this.get(resourceId.subscriptionId(), resourceGroup));
        LinkedList<Pair> resourceTypeNames = new LinkedList<Pair>();
        for (resourceId = ResourceId.fromString((String)id); resourceId != null; resourceId = resourceId.parent()) {
            resourceTypeNames.push(Pair.of((Object)resourceId.resourceType(), (Object)resourceId.name()));
        }
        for (Pair resourceTypeName : resourceTypeNames) {
            resource = (AbstractAzResource)resource.getSubModule((String)resourceTypeName.getLeft()).getOrDraft((String)resourceTypeName.getRight(), resourceGroup);
        }
        return (E)resource;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static {
        AbstractAzService.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzService.java", AbstractAzService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "preload", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzService", "", "", "", "void"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzService", "", "", "", "java.util.stream.Stream"), 74);
    }
}

