/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class Azure {
    private final AzureConfiguration configuration = new AzureConfiguration();
    private static final Azure defaultInstance;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    private Azure() {
    }

    public static synchronized <T extends AzService> T az(Class<T> clazz) {
        AzService service = Optional.ofNullable(Azure.getService(clazz)).orElseGet(() -> {
            ServiceManager.reload();
            return Azure.getService(clazz);
        });
        String message = String.format("Azure service(%s) not supported", clazz.getSimpleName());
        return (T)Optional.ofNullable(service).orElseThrow(() -> new AzureToolkitRuntimeException(message));
    }

    @Nullable
    private static <T extends AzService> T getService(Class<T> clazz) {
        return (T)((AzService)ServiceManager.getServices().stream().filter(clazz::isInstance).map(clazz::cast).findAny().orElse(null));
    }

    @Nullable
    private static AzService getService(String provider) {
        return ServiceManager.getServices().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)provider, (CharSequence)s.getName())).findAny().orElse(null);
    }

    @Nonnull
    public static <T extends AzService> List<T> getServices(Class<T> clazz) {
        return ServiceManager.getServices().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @AzureOperation(name="resource.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public AbstractAzResource<?, ?, ?> getById(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId resourceId = ResourceId.fromString((String)id);
            String provider = Optional.ofNullable(resourceId.providerNamespace()).orElse("Microsoft.Resources");
            AzService service = Azure.getService(provider);
            if (!(service instanceof AbstractAzService)) {
                throw new AzureToolkitRuntimeException("can not find a valid service provider!");
            }
            AbstractAzResource abstractAzResource = (AbstractAzResource)((AbstractAzService)service).getById(id);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return abstractAzResource;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public static Azure az() {
        return defaultInstance;
    }

    public AzureConfiguration config() {
        return this.configuration;
    }

    static {
        Azure.ajc$preClinit();
        defaultInstance = new Azure();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Azure.java", Azure.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getById", "com.microsoft.azure.toolkit.lib.Azure", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource"), 57);
    }

    private static class ServiceManager {
        private static final ServiceLoader<AzService> loader = ServiceLoader.load(AzService.class, Azure.class.getClassLoader());
        private static final List<AzService> services = new ArrayList<AzService>();

        private ServiceManager() {
        }

        public static synchronized List<AzService> getServices() {
            if (services.isEmpty()) {
                ServiceManager.reload();
            }
            return services;
        }

        public static synchronized void reload() {
            loader.reload();
            services.clear();
            loader.forEach(services::add);
        }
    }
}

