/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.resources.models.Location;
import com.azure.resourcemanager.resources.models.RegionType;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount$AjcClosure1;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount$AjcClosure3;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.SharedTokenCacheAccount;
import com.microsoft.azure.toolkit.lib.auth.cli.AzureCliAccount;
import com.microsoft.azure.toolkit.lib.auth.devicecode.DeviceCodeAccount;
import com.microsoft.azure.toolkit.lib.auth.managedidentity.ManagedIdentityAccount;
import com.microsoft.azure.toolkit.lib.auth.oauth.OAuthAccount;
import com.microsoft.azure.toolkit.lib.auth.serviceprincipal.ServicePrincipalAccount;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AzureAccount
implements IAzureAccount {
    private static final Logger log;
    @Nullable
    private AtomicReference<Account> accountRef;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Account account() throws AzureToolkitAuthenticationException {
        return Optional.ofNullable(this.accountRef).map(AtomicReference::get).orElseThrow(() -> new AzureToolkitAuthenticationException("you are not signed-in."));
    }

    public Account login(@Nonnull AuthType type) {
        return this.login(new AuthConfiguration(type), Azure.az().config().isAuthPersistenceEnabled());
    }

    public Account login(@Nonnull AuthConfiguration config) {
        return this.login(config, Azure.az().config().isAuthPersistenceEnabled());
    }

    public Account login(@Nonnull Account account) {
        if (this.isLoggedIn()) {
            AzureMessager.getMessager().warning("You have already logged in!");
            return this.account();
        }
        if (account.getType() == AuthType.OAUTH2 || account.getType() == AuthType.DEVICE_CODE) {
            log.info(String.format("Auth type: %s", TextUtils.cyan((String)account.getType().name())));
        }
        this.accountRef = new AtomicReference();
        AzureEventBus.emit((String)"account.logging_in.type", (Object)((Object)account.getType()));
        account.login();
        if (this.accountRef.compareAndSet(null, account)) {
            AzureEventBus.emit((String)"account.logged_in.account", (Object)account);
        }
        return account;
    }

    @AzureOperation(name="internal/account.login.type", params={"config.getType()"})
    public synchronized Account login(@Nonnull AuthConfiguration config, boolean enablePersistence) {
        AuthConfiguration authConfiguration = config;
        boolean bl = enablePersistence;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)authConfiguration, (Object)Conversions.booleanObject((boolean)bl));
        try {
            Account account;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.isLoggedIn()) {
                AzureMessager.getMessager().warning("You have already logged in!");
                account = this.account();
            } else {
                Account account2;
                AzureEnvironment env = ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault();
                AzureEnvironment configEnv = AzureEnvironmentUtils.stringToAzureEnvironment(config.getEnvironment());
                if (Objects.nonNull(configEnv) && env != configEnv) {
                    String msg = String.format("you have switched to Azure Cloud '%s' since the last time you signed in.", AzureEnvironmentUtils.getCloudName(env));
                    this.logout();
                    throw new AzureToolkitAuthenticationException(msg);
                }
                AuthType type = config.getType();
                OperationContext.current().setTelemetryProperty("authType", type.name());
                OperationContext.current().setTelemetryProperty("azureEnvironment", AzureEnvironmentUtils.azureEnvironmentToString(env));
                List<String> selected = config.getSelectedSubscriptions();
                boolean restoring = CollectionUtils.isNotEmpty(selected);
                if (type == AuthType.AUTO) {
                    account2 = this.getAutoAccount(config);
                } else if (type == AuthType.SERVICE_PRINCIPAL) {
                    account2 = new ServicePrincipalAccount(config);
                } else if (type == AuthType.MANAGED_IDENTITY) {
                    account2 = new ManagedIdentityAccount(config);
                } else if (type == AuthType.AZURE_CLI) {
                    account2 = new AzureCliAccount(config);
                } else if (type == AuthType.OAUTH2) {
                    account2 = restoring ? new SharedTokenCacheAccount(config) : new OAuthAccount(config);
                } else if (type == AuthType.DEVICE_CODE) {
                    account2 = restoring ? new SharedTokenCacheAccount(config) : new DeviceCodeAccount(config);
                } else {
                    throw new AzureToolkitRuntimeException(String.format("Unsupported auth type '%s'", new Object[]{type}));
                }
                account2.setPersistenceEnabled(enablePersistence);
                log.info(String.format("Auth type: %s", TextUtils.cyan((String)account2.getType().name())));
                this.accountRef = new AtomicReference();
                AzureEventBus.emit((String)"account.logging_in.type", (Object)((Object)account2.getType()));
                try {
                    account2.login();
                }
                catch (Throwable t) {
                    AzureEventBus.emit((String)"account.failed_logging_in.type", (Object)((Object)account2.getType()));
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
                    if (rootCause instanceof UnsatisfiedLinkError || rootCause instanceof NoClassDefFoundError) {
                        Action disableAuthCache = AzureActionManager.getInstance().getAction(Action.DISABLE_AUTH_CACHE).bind(new Object()).withLabel("Disable Auth Cache");
                        throw new AzureToolkitRuntimeException("`msal4j` doesn't work well on some machines.", t, "please try disabling auth cache in \"Azure Settings\" and re-signing in", new Object[]{disableAuthCache, Action.OPEN_AZURE_SETTINGS});
                    }
                    throw t;
                }
                if (this.accountRef.compareAndSet(null, account2)) {
                    if (restoring) {
                        account2.setSelectedSubscriptions(selected);
                    }
                    AzureEventBus.emit((String)"account.logged_in.account", (Object)account2);
                }
                account = account2;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return account;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public Account getAutoAccount() {
        return this.getAutoAccount(new AuthConfiguration(AuthType.AUTO));
    }

    @Nonnull
    private Account getAutoAccount(@Nonnull AuthConfiguration config) {
        ArrayList<Account> candidates = new ArrayList<Account>(8);
        candidates.add(new ServicePrincipalAccount(config));
        candidates.add(new ManagedIdentityAccount(config));
        candidates.add(new AzureCliAccount(config));
        candidates.add(new OAuthAccount(config));
        Account account = ((Stream)candidates.stream().parallel()).filter(Account::checkAvailable).findFirst().orElseGet(() -> new DeviceCodeAccount(config));
        config.setType(account.getType());
        return account;
    }

    public synchronized void logout() {
        Account oldAccount = Optional.ofNullable(this.accountRef).map(r -> r.getAndSet(null)).orElse(null);
        if (Objects.nonNull(oldAccount)) {
            oldAccount.logout();
            this.accountRef = null;
            AzureEventBus.emit((String)"account.logged_out.account", (Object)oldAccount);
        }
    }

    public boolean isLoggedIn() {
        return Optional.ofNullable(this.accountRef).map(AtomicReference::get).map(Account::isLoggedInCompletely).isPresent();
    }

    public boolean isLoggingIn() {
        return Objects.nonNull(this.accountRef) && Objects.isNull(this.accountRef.get());
    }

    @Nullable
    public Account getAccount() {
        return Optional.ofNullable(this.accountRef).map(AtomicReference::get).orElse(null);
    }

    public String getName() {
        return "Microsoft.Account";
    }

    public void refresh() {
    }

    @Cacheable(cacheName="subscriptions/{}/regions", key="$subscriptionId")
    public List<Region> listRegions(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAccount$AjcClosure1 azureAccount$AjcClosure1 = new AzureAccount$AjcClosure1(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAccount$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Region> listRegions() {
        return (List)Flux.fromIterable((Iterable)((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions()).parallel().map(Subscription::getId).map(this::listRegions).sequential().collectList().map(regionSet -> regionSet.stream().flatMap(Collection::stream).filter(Utils.distinctByKey(region -> StringUtils.lowerCase((String)region.getLabel()))).collect(Collectors.toList())).block();
    }

    @Cacheable(cacheName="subscriptions/{}", key="$subscriptionId")
    private com.azure.resourcemanager.resources.models.Subscription getSubscription(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAccount$AjcClosure3 azureAccount$AjcClosure3 = new AzureAccount$AjcClosure3(objectArray);
        return (com.azure.resourcemanager.resources.models.Subscription)CacheManager.aspectOf().aroundCacheable(azureAccount$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    static {
        AzureAccount.ajc$preClinit();
        log = LoggerFactory.getLogger(AzureAccount.class);
    }

    static final /* synthetic */ List listRegions_aroundBody0(AzureAccount ajc$this, String subscriptionId, JoinPoint joinPoint) {
        return ajc$this.getSubscription(subscriptionId).listLocations().stream().filter(l -> l.regionType() == RegionType.PHYSICAL).map(Location::region).distinct().map(region -> Region.fromName((String)region.name())).collect(Collectors.toList());
    }

    static final /* synthetic */ com.azure.resourcemanager.resources.models.Subscription getSubscription_aroundBody2(AzureAccount ajc$this, String subscriptionId, JoinPoint joinPoint) {
        return (com.azure.resourcemanager.resources.models.Subscription)AbstractAzServiceSubscription.getResourceManager((String)subscriptionId).subscriptions().getById(subscriptionId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAccount.java", AzureAccount.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "login", "com.microsoft.azure.toolkit.lib.auth.AzureAccount", "com.microsoft.azure.toolkit.lib.auth.AuthConfiguration:boolean", "config:enablePersistence", "", "com.microsoft.azure.toolkit.lib.auth.Account"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRegions", "com.microsoft.azure.toolkit.lib.auth.AzureAccount", "java.lang.String", "subscriptionId", "", "java.util.List"), 208);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSubscription", "com.microsoft.azure.toolkit.lib.auth.AzureAccount", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.resources.models.Subscription"), 231);
    }
}

