/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.SharedTokenCacheCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import javax.annotation.Nonnull;

public class SharedTokenCacheAccount
extends Account {
    public SharedTokenCacheAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        AuthConfiguration config = this.getConfig();
        return ((SharedTokenCacheCredentialBuilder)((SharedTokenCacheCredentialBuilder)new SharedTokenCacheCredentialBuilder().tokenCachePersistenceOptions(PERSISTENCE_OPTIONS).tenantId(config.getTenant())).username(config.getUsername()).clientId(config.getClient())).build();
    }

    @Override
    public boolean checkAvailable() {
        return this.getManagementToken().isPresent();
    }

    @Override
    public AuthType getType() {
        return this.getConfig().getType();
    }
}

