/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.model;

import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.tools.auth.AzureIdentityCredentialTokenCredentials;
import com.microsoft.azure.tools.auth.model.AuthMethod;
import com.microsoft.azure.tools.common.util.TextUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AzureCredentialWrapper {
    private AuthMethod authMethod;
    private TokenCredential tokenCredential;
    private AzureEnvironment env;
    private String defaultSubscriptionId;
    private String[] filteredSubscriptionIds;
    private String tenantId;

    public AzureCredentialWrapper(AuthMethod method, TokenCredential tokenCredential, AzureEnvironment env) {
        Objects.requireNonNull(method, "authMethod is null");
        Objects.requireNonNull(tokenCredential, "tokenCredential is null");
        Objects.requireNonNull(tokenCredential, "env is null");
        this.authMethod = method;
        this.tokenCredential = tokenCredential;
        this.env = env;
    }

    public AzureCredentialWrapper withDefaultSubscriptionId(String defaultSubscriptionId) {
        this.defaultSubscriptionId = defaultSubscriptionId;
        return this;
    }

    public AzureCredentialWrapper withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AzureCredentialWrapper withFilteredSubscriptionIds(String[] filteredSubscriptionIds) {
        this.filteredSubscriptionIds = filteredSubscriptionIds;
        return this;
    }

    public String getCredentialDescription() {
        ArrayList<String> details = new ArrayList<String>();
        details.add(String.format("Auth method: %s", TextUtils.cyan((String)this.authMethod.toString())));
        if (StringUtils.isNotBlank((CharSequence)this.tenantId)) {
            details.add(String.format("Tenant id: %s", TextUtils.cyan((String)this.tenantId)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.defaultSubscriptionId)) {
            details.add(String.format("Default subscription: %s", TextUtils.cyan((String)this.defaultSubscriptionId)));
        }
        return StringUtils.join((Object[])details.toArray(), (String)"\n");
    }

    public AzureTokenCredentials getAzureTokenCredentials() {
        return new AzureIdentityCredentialTokenCredentials(this.env, this.tenantId, this.tokenCredential);
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public AzureEnvironment getEnv() {
        return this.env;
    }

    public String getDefaultSubscriptionId() {
        return this.defaultSubscriptionId;
    }

    public String[] getFilteredSubscriptionIds() {
        return this.filteredSubscriptionIds;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

