/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core.oauth;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.InteractiveBrowserCredential;
import com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.tools.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.tools.auth.exception.DesktopNotSupportedException;
import com.microsoft.azure.tools.auth.exception.LoginFailureException;
import com.microsoft.azure.tools.auth.model.AuthMethod;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import java.awt.Desktop;
import me.alexpanov.net.FreePortFinder;

public class OAuthCredentialRetriever
extends AbstractCredentialRetriever {
    private static final String AZURE_TOOLKIT_CLIENT_ID = "777acee8-5286-4d6e-8b05-f7c851d8ed0a";

    public OAuthCredentialRetriever(AzureEnvironment env) {
        super(env);
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() throws LoginFailureException {
        if (!OAuthCredentialRetriever.isBrowserAvailable()) {
            throw new DesktopNotSupportedException("Not able to launch a browser to log you in.");
        }
        InteractiveBrowserCredential interactiveBrowserCredential = ((InteractiveBrowserCredentialBuilder)new InteractiveBrowserCredentialBuilder().clientId(AZURE_TOOLKIT_CLIENT_ID)).redirectUrl("http://localhost:" + FreePortFinder.findFreeLocalPort()).build();
        return new AzureCredentialWrapper(AuthMethod.OAUTH2, (TokenCredential)interactiveBrowserCredential, this.getAzureEnvironment());
    }

    private static boolean isBrowserAvailable() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }
}

