/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core.maven;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.implementation.util.ScopeUtil;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.tools.auth.core.maven.AzureContextExecutor;
import com.microsoft.azure.tools.auth.core.maven.AzureCredential;
import com.microsoft.azure.tools.common.util.JsonUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import reactor.core.publisher.Mono;
import rx.exceptions.Exceptions;

public class MavenLoginHelper {
    private static final String CLIENT_ID = "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
    private static final String COMMON_TENANT = "common";
    private static final String AZURE_FOLDER = ".azure";
    private static final String USER_HOME = "user.home";
    private static final String AZURE_CONFIG_DIR = "AZURE_CONFIG_DIR";
    private static final String AZURE_SECRET_FILE = "azure-secret.json";
    private static final String AZURE_PROFILE_NAME = "azureProfile.json";
    private static final String AZURE_TOKEN_NAME = "accessTokens.json";

    public static File getAzureConfigFolder() {
        return StringUtils.isNotBlank((CharSequence)System.getenv(AZURE_CONFIG_DIR)) ? new File(System.getenv(AZURE_CONFIG_DIR)) : Paths.get(System.getProperty(USER_HOME), AZURE_FOLDER).toFile();
    }

    public static File getAzureSecretFile() {
        return new File(MavenLoginHelper.getAzureConfigFolder(), AZURE_SECRET_FILE);
    }

    public static boolean existsAzureSecretFile() {
        File azureSecretFile = MavenLoginHelper.getAzureSecretFile();
        return azureSecretFile.exists() && azureSecretFile.isFile() && azureSecretFile.length() > 0L;
    }

    public static AzureCredential readAzureCredentials(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be null.");
        }
        String jsonStr = FileUtils.readFileToString((File)file, (String)"utf8");
        return (AzureCredential)JsonUtils.fromJson((String)jsonStr, AzureCredential.class);
    }

    public static TokenCredential getMavenAzureLoginCredentialsTrack2(final @Nonnull AzureCredential credentials, final @Nonnull AzureEnvironment env) throws IOException {
        return new TokenCredential(){
            private Map<String, AzureTokenCredentials> tokenCache = new ConcurrentHashMap<String, AzureTokenCredentials>();

            public Mono<AccessToken> getToken(TokenRequestContext request) {
                String resource = ScopeUtil.scopesToResource((List)request.getScopes());
                AzureTokenCredentials track1Token = this.tokenCache.computeIfAbsent(resource, ignore -> MavenLoginHelper.getMavenAzureLoginCredentialsTrack1(credentials, env));
                return Mono.fromCallable(() -> {
                    try {
                        return new AccessToken(track1Token.getToken(resource), OffsetDateTime.MAX);
                    }
                    catch (IOException e) {
                        Exceptions.propagate((Throwable)e);
                        return null;
                    }
                });
            }
        };
    }

    public static AzureTokenCredentials getMavenAzureLoginCredentialsTrack1(final AzureCredential credentials, final AzureEnvironment env) {
        AzureTokenCredentials azureTokenCredentials = new AzureTokenCredentials(env, null){

            public String getToken(String resource) throws IOException {
                String accessToken = credentials.getAccessToken();
                String accessTokenWithoutSignature = accessToken.substring(0, accessToken.lastIndexOf(46) + 1);
                try {
                    Jwt jwtToken = Jwts.parser().parseClaimsJwt(accessTokenWithoutSignature);
                    if (((Claims)jwtToken.getBody()).getExpiration().after(DateUtils.addMinutes((Date)new Date(), (int)1))) {
                        return accessToken;
                    }
                }
                catch (ExpiredJwtException jwtToken) {
                    // empty catch block
                }
                try {
                    AzureCredential newCredentials = MavenLoginHelper.refreshToken(env, credentials.getRefreshToken());
                    credentials.setAccessToken(newCredentials.getAccessToken());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof AuthenticationException) {
                        throw (AuthenticationException)e.getCause();
                    }
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(String.format("Error happened during refreshing access token, due to error: %s.", e.getMessage()));
                }
                return credentials.getAccessToken();
            }
        };
        if (StringUtils.isNotBlank((CharSequence)credentials.getDefaultSubscription())) {
            azureTokenCredentials.withDefaultSubscriptionId(credentials.getDefaultSubscription());
        }
        return azureTokenCredentials;
    }

    static AzureCredential refreshToken(AzureEnvironment env, String refreshToken) throws MalformedURLException, InterruptedException, ExecutionException {
        if (env == null) {
            throw new IllegalArgumentException("Parameter 'env' cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw new IllegalArgumentException("Parameter 'refreshToken' cannot be empty.");
        }
        return new AzureContextExecutor(MavenLoginHelper.baseURL(env), authenticationContext -> (AuthenticationResult)authenticationContext.acquireTokenByRefreshToken(refreshToken, CLIENT_ID, env.managementEndpoint(), null).get()).execute();
    }

    static String baseURL(AzureEnvironment env) {
        return env.activeDirectoryEndpoint() + COMMON_TENANT;
    }
}

