/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core.azurecli;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.AzureCliCredentialBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.tools.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.tools.auth.core.azurecli.AzureCliAccountProfile;
import com.microsoft.azure.tools.auth.exception.LoginFailureException;
import com.microsoft.azure.tools.auth.model.AuthMethod;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.tools.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.tools.common.exception.CommandExecuteException;
import com.microsoft.azure.tools.common.util.CommandUtil;
import com.microsoft.azure.tools.common.util.JsonUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AzureCliCredentialRetriever
extends AbstractCredentialRetriever {
    private static final String CLOUD_SHELL_ENV_KEY = "ACC_CLOUD";

    public AzureCliCredentialRetriever(AzureEnvironment env) {
        super(env);
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() throws LoginFailureException {
        AzureCliAccountProfile accountInfo = AzureCliCredentialRetriever.getProfile();
        AzureCliCredentialRetriever.checkAzureEnvironmentConflict(this.env, AzureEnvironmentUtils.stringToAzureEnvironment(accountInfo.getEnvironment()));
        AzureCliCredential cliCredential = new AzureCliCredentialBuilder().build();
        this.validateTokenCredential((TokenCredential)cliCredential);
        return new AzureCredentialWrapper(AzureCliCredentialRetriever.isInCloudShell() ? AuthMethod.CLOUD_SHELL : AuthMethod.AZURE_CLI, (TokenCredential)cliCredential, this.getAzureEnvironment()).withDefaultSubscriptionId(accountInfo.getSubscriptionId()).withTenantId(accountInfo.getTenantId());
    }

    private static void checkAzureEnvironmentConflict(AzureEnvironment env, AzureEnvironment envCli) throws LoginFailureException {
        if (env != null && envCli != null && !Objects.equals(env, envCli)) {
            throw new LoginFailureException(String.format("The azure cloud from azure cli '%s' doesn't match with your auth configuration, you can change it by executing 'az cloud set --name=%s' command to change the cloud in azure cli.", AzureEnvironmentUtils.azureEnvironmentToString(envCli), AzureEnvironmentUtils.getCloudNameForAzureCli(env)));
        }
    }

    private static AzureCliAccountProfile getProfile() throws LoginFailureException {
        try {
            String accountInfo = CommandUtil.executeCommandAndGetOutput((String)"az account show", null);
            JsonObject accountObject = (JsonObject)JsonUtils.getGson().fromJson(accountInfo, JsonObject.class);
            String tenantId = accountObject.get("tenantId").getAsString();
            String environment = accountObject.get("environmentName").getAsString();
            String subscriptionId = accountObject.get("id").getAsString();
            String userName = accountObject.get("user").getAsJsonObject().get("name").getAsString();
            String userType = accountObject.get("user").getAsJsonObject().get("type").getAsString();
            return new AzureCliAccountProfile(tenantId, environment, userName, userType, subscriptionId);
        }
        catch (JsonParseException | CommandExecuteException | IOException | InterruptedException | NullPointerException ex) {
            throw new LoginFailureException(String.format("Cannot get account info from azure cli through `az account show`, please run `az login` to login your Azure Cli, detailed error: %s", ex.getMessage()));
        }
    }

    private static boolean isInCloudShell() {
        return StringUtils.isNotBlank((CharSequence)System.getenv(CLOUD_SHELL_ENV_KEY));
    }
}

