/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.azurecli;

import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.core.azurecli.AzureCliTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.auth.util.AzureCliUtils;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AzureCliAccount
extends Account {
    @Override
    public AuthType getAuthType() {
        return AuthType.AZURE_CLI;
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.fromCallable(() -> {
            List<AzureCliSubscription> cliSubs = AzureCliUtils.listSubscriptions();
            if (cliSubs.isEmpty()) {
                throw new AzureToolkitAuthenticationException("Cannot find any subscriptions in current account.");
            }
            AzureCliSubscription defaultSub = cliSubs.stream().filter(AzureCliSubscription::isSelected).findFirst().orElse(cliSubs.get(0));
            AzureEnvironment configuredEnv = ((AzureCloud)Azure.az(AzureCloud.class)).get();
            if (configuredEnv != null && defaultSub.getEnvironment() != configuredEnv) {
                throw new AzureToolkitAuthenticationException(String.format("The azure cloud from azure cli '%s' doesn't match with your auth configuration, you can change it by executing 'az cloud set --name=%s' command to change the cloud in azure cli.", AzureEnvironmentUtils.getCloudName(defaultSub.getEnvironment()), AzureEnvironmentUtils.getCloudName(configuredEnv)));
            }
            String userEmail = defaultSub.getEmail();
            List<Subscription> userSubs = cliSubs.stream().filter(s -> Objects.equals(userEmail, s.getEmail())).collect(Collectors.toList());
            List<String> userTenants = userSubs.stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList());
            List<String> userSelectedSubs = userSubs.stream().filter(Subscription::isSelected).map(Subscription::getId).collect(Collectors.toList());
            this.entity.setEnvironment(defaultSub.getEnvironment());
            this.entity.setEmail(userEmail);
            this.entity.setTenantIds(userTenants);
            this.entity.setSubscriptions(userSubs);
            this.entity.setSelectedSubscriptionIds(userSelectedSubs);
            return true;
        });
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        return Mono.just((Object)new AzureCliTokenCredentialManager(this.entity.getEnvironment()));
    }

    @Override
    public String getClientId() {
        return "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
    }
}

