/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.SharedTokenCacheCredential;
import com.azure.identity.SharedTokenCacheCredentialBuilder;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.resourcemanager.resources.models.Location;
import com.azure.resourcemanager.resources.models.RegionType;
import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount$AjcClosure1;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount$AjcClosure3;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.RefreshTokenTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.core.azurecli.AzureCliAccount;
import com.microsoft.azure.toolkit.lib.auth.core.devicecode.DeviceCodeAccount;
import com.microsoft.azure.toolkit.lib.auth.core.oauth.OAuthAccount;
import com.microsoft.azure.toolkit.lib.auth.core.serviceprincipal.ServicePrincipalAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.auth.model.AccountEntity;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AzureAccount
implements IAzureAccount {
    private Account account;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public Account account() throws AzureToolkitAuthenticationException {
        return Optional.ofNullable(this.account).orElseThrow(() -> new AzureToolkitAuthenticationException("you are not signed-in."));
    }

    public Account account(@Nonnull AccountEntity accountEntity) {
        return (Account)this.restoreLogin(accountEntity).block();
    }

    public List<Account> accounts() {
        return (List)Flux.fromIterable(AzureAccount.buildAccountMap().values()).map(Supplier::get).collectList().block();
    }

    public boolean isSignedIn() {
        return Objects.nonNull(this.account);
    }

    public AzureAccount login(@Nonnull AuthType type) {
        return this.login(type, false);
    }

    public AzureAccount login(@Nonnull Account targetAccount) {
        return this.login(targetAccount, false);
    }

    public AzureAccount login(@Nonnull AuthConfiguration auth) {
        return this.login(auth, false);
    }

    public AzureAccount login(@Nonnull AuthType type, boolean enablePersistence) {
        if (type == AuthType.DEVICE_CODE) {
            throw new IllegalArgumentException("You shall not call login in sync mode for device code login, you need to call loginAsync instead.");
        }
        return this.finishLogin(this.loginAsync(type, enablePersistence));
    }

    public AzureAccount login(@Nonnull Account targetAccount, boolean enablePersistence) {
        if (targetAccount.getAuthType() == AuthType.DEVICE_CODE) {
            throw new IllegalArgumentException("You shall not call login in sync mode for device code login, you need to call loginAsync instead.");
        }
        return this.finishLogin(this.loginAsync(targetAccount, enablePersistence));
    }

    public AzureAccount login(@Nonnull AuthConfiguration auth, boolean enablePersistence) {
        if (auth.getType() == AuthType.DEVICE_CODE) {
            throw new IllegalArgumentException("You shall not call login in sync mode for device code login, you need to call loginAsync instead.");
        }
        return this.finishLogin(this.loginAsync(auth, enablePersistence));
    }

    void setAccount(Account account) {
        this.account = account;
        AzureEventBus.emit((String)"account.login.account", (Object)account);
    }

    public void logout() {
        if (this.account != null) {
            Account tempAccount = this.account;
            this.account = null;
            tempAccount.logout();
            AzureEventBus.emit((String)"account.logout.account", (Object)tempAccount);
        }
    }

    private Mono<Account> restoreLogin(@Nonnull AccountEntity accountEntity) {
        Account target;
        Preconditions.checkNotNull((Object)accountEntity.getEnvironment(), (Object)"Azure environment for account entity is required.");
        Preconditions.checkNotNull((Object)((Object)accountEntity.getType()), (Object)"Auth type for account entity is required.");
        if (Arrays.asList(AuthType.DEVICE_CODE, AuthType.OAUTH2).contains((Object)accountEntity.getType())) {
            AzureEnvironmentUtils.setupAzureEnvironment(accountEntity.getEnvironment());
            SharedTokenCacheCredentialBuilder builder = new SharedTokenCacheCredentialBuilder();
            SharedTokenCacheCredential credential = ((SharedTokenCacheCredentialBuilder)((SharedTokenCacheCredentialBuilder)builder.tokenCachePersistenceOptions(new TokenCachePersistenceOptions().setName("azure-toolkit.cache")).username(accountEntity.getEmail()).tenantId(accountEntity.getTenantIds() == null ? "organizations" : accountEntity.getTenantIds().get(0))).clientId(accountEntity.getClientId())).build();
            target = new SimpleAccount(accountEntity, (TokenCredential)credential);
        } else if (Arrays.asList(AuthType.VSCODE, AuthType.AZURE_CLI).contains((Object)accountEntity.getType())) {
            target = AzureAccount.buildAccountMap().get((Object)accountEntity.getType()).get();
        } else {
            return Mono.error((Throwable)((Object)new AzureToolkitAuthenticationException(String.format("login for auth type '%s' cannot be restored.", new Object[]{accountEntity.getType()}))));
        }
        return target.login().map(ac -> {
            if (ac.getEnvironment() != accountEntity.getEnvironment()) {
                throw new AzureToolkitAuthenticationException(String.format("you have changed the azure cloud to '%s' for auth type: '%s' since last time you signed in.", new Object[]{AzureEnvironmentUtils.getCloudName(ac.getEnvironment()), accountEntity.getType()}));
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)ac.entity.getEmail(), (CharSequence)accountEntity.getEmail())) {
                throw new AzureToolkitAuthenticationException(String.format("you have changed the account from '%s' to '%s' since last time you signed in.", accountEntity.getEmail(), ac.entity.getEmail()));
            }
            return ac;
        }).doOnSuccess(this::setAccount);
    }

    public String getName() {
        return "Microsoft.Account";
    }

    public void refresh() {
    }

    public Mono<Account> loginAsync(@Nonnull AuthType type, boolean enablePersistence) {
        Objects.requireNonNull(type, "Please specify auth type in auth configuration.");
        AuthConfiguration auth = new AuthConfiguration();
        auth.setType(type);
        return this.loginAsync(auth, enablePersistence);
    }

    public Mono<Account> loginAsync(@Nonnull AuthConfiguration auth, boolean enablePersistence) {
        Account targetAccount;
        Objects.requireNonNull(auth, "Auth configuration is required for login.");
        Objects.requireNonNull(auth.getType(), "Auth type is required for login.");
        Preconditions.checkArgument((auth.getType() != AuthType.AUTO ? 1 : 0) != 0, (Object)"Auth type 'auto' is illegal for login.");
        if (auth.getEnvironment() != null) {
            ((AzureCloud)Azure.az(AzureCloud.class)).set(auth.getEnvironment());
        }
        AuthType type = auth.getType();
        if (auth.getType() == AuthType.SERVICE_PRINCIPAL) {
            targetAccount = new ServicePrincipalAccount(auth);
        } else {
            Map<AuthType, Supplier<Account>> accountByType = AzureAccount.buildAccountMap();
            if (!accountByType.containsKey((Object)type)) {
                return Mono.error((Throwable)new LoginFailureException(String.format("Unsupported auth type '%s', supported values are: %s.", new Object[]{type, accountByType.keySet().stream().map(Object::toString).map(StringUtils::lowerCase).collect(Collectors.joining(", "))})));
            }
            targetAccount = accountByType.get((Object)type).get();
        }
        return this.loginAsync(targetAccount, enablePersistence);
    }

    public Mono<Account> loginAsync(Account targetAccount, boolean enablePersistence) {
        Objects.requireNonNull(targetAccount, "Please specify account to login.");
        targetAccount.setEnablePersistence(enablePersistence);
        return targetAccount.login();
    }

    @Cacheable(cacheName="Regions", key="$subscriptionId")
    public List<Region> listRegions(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAccount$AjcClosure1 azureAccount$AjcClosure1 = new AzureAccount$AjcClosure1(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAccount$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Region> listRegions() {
        return (List)Flux.fromIterable((Iterable)((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions()).parallel().map(Subscription::getId).map(this::listRegions).sequential().collectList().map(regionSet -> regionSet.stream().flatMap(Collection::stream).filter(Utils.distinctByKey(region -> StringUtils.lowerCase((String)region.getLabel()))).collect(Collectors.toList())).block();
    }

    private static Region toRegion(com.azure.core.management.Region region) {
        return Optional.of(Region.fromName((String)region.name())).orElseGet(() -> new Region(region.name(), region.label() + "*"));
    }

    private AzureAccount finishLogin(Mono<Account> mono) {
        try {
            mono.flatMap(Account::continueLogin).block();
            return this;
        }
        catch (Throwable ex) {
            throw new AzureToolkitAuthenticationException("encountering error: " + ex.getMessage());
        }
    }

    private static Map<AuthType, Supplier<Account>> buildAccountMap() {
        LinkedHashMap<AuthType, Supplier<Account>> map = new LinkedHashMap<AuthType, Supplier<Account>>();
        map.put(AuthType.AZURE_CLI, AzureCliAccount::new);
        map.put(AuthType.OAUTH2, OAuthAccount::new);
        map.put(AuthType.DEVICE_CODE, DeviceCodeAccount::new);
        return map;
    }

    @Cacheable(cacheName="Subscription", key="$subscriptionId")
    private com.azure.resourcemanager.resources.models.Subscription getSubscription(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAccount$AjcClosure3 azureAccount$AjcClosure3 = new AzureAccount$AjcClosure3(objectArray);
        return (com.azure.resourcemanager.resources.models.Subscription)CacheManager.aspectOf().aroundCacheable(azureAccount$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    static {
        AzureAccount.ajc$preClinit();
    }

    static final /* synthetic */ List listRegions_aroundBody0(AzureAccount ajc$this, String subscriptionId, JoinPoint joinPoint) {
        return ajc$this.getSubscription(subscriptionId).listLocations().stream().filter(l -> l.regionType() == RegionType.PHYSICAL).map(Location::region).distinct().map(AzureAccount::toRegion).collect(Collectors.toList());
    }

    static final /* synthetic */ com.azure.resourcemanager.resources.models.Subscription getSubscription_aroundBody2(AzureAccount ajc$this, String subscriptionId, JoinPoint joinPoint) {
        return (com.azure.resourcemanager.resources.models.Subscription)AbstractAzResourceManager.getResourceManager((String)subscriptionId).subscriptions().getById(subscriptionId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAccount.java", AzureAccount.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRegions", "com.microsoft.azure.toolkit.lib.auth.AzureAccount", "java.lang.String", "subscriptionId", "", "java.util.List"), 250);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSubscription", "com.microsoft.azure.toolkit.lib.auth.AzureAccount", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.resources.models.Subscription"), 294);
    }

    static class SimpleAccount
    extends Account {
        private final TokenCredential credential;

        public SimpleAccount(@Nonnull AccountEntity accountEntity, @Nonnull TokenCredential credential) {
            Preconditions.checkNotNull((Object)accountEntity.getEnvironment(), (Object)"Azure environment for account entity is required.");
            Preconditions.checkNotNull((Object)((Object)accountEntity.getType()), (Object)"Auth type for account entity is required.");
            this.entity = new AccountEntity();
            this.entity.setClientId(accountEntity.getClientId());
            this.entity.setType(accountEntity.getType());
            this.entity.setEmail(accountEntity.getEmail());
            this.entity.setEnvironment(accountEntity.getEnvironment());
            this.entity.setTenantIds(accountEntity.getTenantIds());
            this.entity.setSubscriptions(accountEntity.getSubscriptions());
            this.credential = credential;
        }

        @Override
        protected Mono<TokenCredentialManager> createTokenCredentialManager() {
            AzureEnvironment env = this.entity.getEnvironment();
            return RefreshTokenTokenCredentialManager.createTokenCredentialManager(env, this.getClientId(), this.createCredential());
        }

        private TokenCredential createCredential() {
            return this.credential;
        }

        @Override
        public AuthType getAuthType() {
            return this.entity.getType();
        }

        @Override
        protected String getClientId() {
            return this.entity.getClientId();
        }

        @Override
        protected Mono<Boolean> preLoginCheck() {
            return Mono.just((Object)true);
        }
    }
}

