/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.WebAppStackInner;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class WebAppServiceSubscription
extends AppServiceServiceSubscription {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};

    protected WebAppServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureAppService service) {
        super(subscriptionId, service);
    }

    protected WebAppServiceSubscription(@Nonnull AppServiceManager remote, @Nonnull AzureAppService service) {
        super(remote, service);
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.getWebAppModule());
    }

    @Nonnull
    public List<WebAppRuntime> listWebAppMajorRuntimes() {
        if (!WebAppWindowsRuntime.isLoaded() && !WebAppLinuxRuntime.isLoaded()) {
            this.loadRuntimes();
        }
        return Stream.concat(WebAppWindowsRuntime.getMajorRuntimes().stream(), WebAppLinuxRuntime.getMajorRuntimes().stream()).collect(Collectors.toList());
    }

    public synchronized void loadRuntimes() {
        this.loadRuntimesUsingHttpPipeline();
    }

    public synchronized void loadRuntimesUsingSdk() {
        AppServiceManager remote = (AppServiceManager)this.getRemote();
        if (Objects.isNull(remote)) {
            return;
        }
        if (WebAppWindowsRuntime.isLoaded() && WebAppLinuxRuntime.isLoaded()) {
            return;
        }
        Map<String, WebAppStackInner> stacks = ((WebSiteManagementClient)remote.serviceClient()).getProviders().getWebAppStacksAsync().toStream().filter(stack -> StringUtils.equalsAnyIgnoreCase((CharSequence)stack.name(), (CharSequence[])new CharSequence[]{"javacontainers", "java"})).collect(Collectors.toMap(s -> s.name().toLowerCase(), s -> s));
        List javaStacks = stacks.get("java").majorVersions();
        List containerStacks = stacks.get("javacontainers").majorVersions();
        WebAppLinuxRuntime.loadAllWebAppLinuxRuntimes(javaStacks, containerStacks);
        WebAppWindowsRuntime.loadAllWebAppWindowsRuntimes(javaStacks, containerStacks);
    }

    public synchronized void loadRuntimesUsingHttpPipeline() {
        AppServiceManager remote = (AppServiceManager)this.getRemote();
        if (Objects.isNull(remote)) {
            return;
        }
        if (WebAppWindowsRuntime.isLoaded() && WebAppLinuxRuntime.isLoaded()) {
            return;
        }
        Map<String, Object> result = this.getRuntimesUsingHttpPipeline(remote);
        if (result.isEmpty()) {
            return;
        }
        List stacksList = (List)Utils.get(result, (String)"$.value");
        Map<String, Object> stacks = stacksList.stream().filter(s -> StringUtils.equalsAnyIgnoreCase((CharSequence)((CharSequence)s.get("name")), (CharSequence[])new CharSequence[]{"javacontainers", "java"})).collect(Collectors.toMap(s -> ((String)s.get("name")).toLowerCase(), s -> s));
        List javaStacks = (List)Utils.get(stacks, (String)"$.java.properties.majorVersions");
        List containerStacks = (List)Utils.get(stacks, (String)"$.javacontainers.properties.majorVersions");
        WebAppLinuxRuntime.loadAllWebAppLinuxRuntimesFromMap(javaStacks, containerStacks);
        WebAppWindowsRuntime.loadAllWebAppWindowsRuntimesFromMap(javaStacks, containerStacks);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getRuntimesUsingHttpPipeline(AppServiceManager appServiceManager) {
        HttpPipeline pipeline = appServiceManager.httpPipeline();
        String apiVersion = ((WebSiteManagementClient)appServiceManager.serviceClient()).getApiVersion();
        HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/providers/Microsoft.Web/webAppStacks?api-version=%s", ((WebSiteManagementClient)appServiceManager.serviceClient()).getEndpoint(), apiVersion));
        try (HttpResponse response = (HttpResponse)pipeline.send(request).block();){
            if (!Objects.nonNull(response)) return Collections.emptyMap();
            if (response.getStatusCode() != 200) return Collections.emptyMap();
            String responseBodyString = (String)response.getBodyAsString().block();
            Map map = (Map)mapper.readValue(responseBodyString, typeRef);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

