/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.microsoft.azure.toolkit.lib.appservice.deploy.DeployUtils;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.AzureStorageHelper;
import java.io.File;
import java.time.Period;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class RunFromBlobFunctionDeployHandler
implements IFunctionDeployHandler {
    private static final int SAS_EXPIRE_DATE_BY_YEAR = 10;
    private static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-run-from-packages";
    private static final String UPDATE_ACCESS_LEVEL_TO_PRIVATE = "The blob container '%s' access level was updated to be private";

    @Override
    public void deploy(@Nonnull File file, @Nonnull WebAppBase target) {
        BlobServiceClient storageAccount = DeployUtils.getBlobServiceClient(target);
        BlobClient blob = this.deployArtifactToAzureStorage(target, file, storageAccount);
        String sasToken = AzureStorageHelper.getSASToken(blob, Period.ofYears(10));
        DeployUtils.updateFunctionAppSetting(target, "WEBSITE_RUN_FROM_PACKAGE", sasToken);
    }

    private BlobClient deployArtifactToAzureStorage(WebAppBase deployTarget, File zipPackage, BlobServiceClient storageAccount) {
        AzureMessager.getMessager().info(String.format("Trying to deploy artifact to %s...", deployTarget.name()));
        BlobContainerClient container = this.getOrCreateArtifactContainer(storageAccount);
        String blobName = this.getBlobName(deployTarget, zipPackage);
        BlobClient blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, container.getBlobContainerName(), blobName);
        AzureMessager.getMessager().info(String.format("Successfully deployed the artifact to https://%s", deployTarget.defaultHostname()));
        return blob;
    }

    private BlobContainerClient getOrCreateArtifactContainer(BlobServiceClient storageAccount) {
        BlobContainerClient container = storageAccount.getBlobContainerClient(DEPLOYMENT_PACKAGE_CONTAINER);
        if (!container.exists()) {
            container.createIfNotExists();
        } else {
            this.updateContainerPublicAccessLevel(container);
        }
        return container;
    }

    private void updateContainerPublicAccessLevel(BlobContainerClient container) {
        BlobContainerAccessPolicies permissions = container.getAccessPolicy();
        if (permissions.getBlobAccessType() == null) {
            return;
        }
        container.setAccessPolicy(null, permissions.getIdentifiers());
        AzureMessager.getMessager().info(String.format(UPDATE_ACCESS_LEVEL_TO_PRIVATE, DEPLOYMENT_PACKAGE_CONTAINER));
    }

    private String getBlobName(WebAppBase deployTarget, File zipPackage) {
        String fixedResourceId = StringUtils.replace((String)deployTarget.id(), (String)"/", (String)"-").replaceFirst("-", "");
        return String.format("%s-%s", fixedResourceId, zipPackage.getName());
    }
}

