/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class FunctionApp
extends FunctionAppBase<FunctionApp, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.FunctionApp>
implements Deletable {
    @Nonnull
    private final FunctionAppDeploymentSlotModule deploymentModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected FunctionApp(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull FunctionAppModule module) {
        super(name, resourceGroupName, module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
    }

    protected FunctionApp(@Nonnull FunctionApp origin) {
        super(origin);
        this.deploymentModule = origin.deploymentModule;
    }

    protected FunctionApp(@Nonnull FunctionAppBasic remote, @Nonnull FunctionAppModule module) {
        super(remote.name(), remote.resourceGroupName(), module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    @Override
    @Nullable
    public String getMasterKey() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(com.azure.resourcemanager.appservice.models.FunctionApp::getMasterKey).orElse(null);
    }

    @Override
    @AzureOperation(name="azure/function.enable_remote_debugging.app", params={"this.getName()"})
    public void enableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map appSettings = Optional.ofNullable(this.getAppSettings()).orElseGet(HashMap::new);
            String debugPort = appSettings.getOrDefault("HTTP_PLATFORM_DEBUG_PORT", this.getRemoteDebugPort());
            this.doModify(() -> (WebSiteBase)((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).update()).withWebSocketsEnabled(true).withPlatformArchitecture(PlatformArchitecture.X64).withAppSetting("HTTP_PLATFORM_DEBUG_PORT", appSettings.getOrDefault("HTTP_PLATFORM_DEBUG_PORT", this.getRemoteDebugPort())).withAppSetting("JAVA_OPTS", this.getJavaOptsWithRemoteDebugEnabled(appSettings, debugPort)).apply(), "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="azure/function.disable_remote_debugging.app", params={"this.getName()"})
    public void disableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map<String, String> appSettings = Objects.requireNonNull(this.getAppSettings());
            String javaOpts = this.getJavaOptsWithRemoteDebugDisabled(appSettings);
            this.doModify(() -> {
                if (StringUtils.isEmpty((CharSequence)javaOpts)) {
                    ((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withoutAppSetting("JAVA_OPTS").apply();
                } else {
                    ((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withAppSetting("JAVA_OPTS", javaOpts).apply();
                }
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public List<FunctionEntity> listFunctions(boolean ... force) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(r -> r.listFunctions().stream().map(envelope -> AppServiceUtils.fromFunctionAppEnvelope(envelope, this.getId())).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @AzureOperation(name="azure/function.trigger_function.func", params={"functionName"})
    public void triggerFunction(String functionName, Object input) {
        String string = functionName;
        Object object = input;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)object);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).ifPresent(r -> r.triggerFunction(functionName, input));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/function.swap_slot.app|slot", params={"this.getName()", "slotName"})
    public void swap(String slotName) {
        String string = slotName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> {
                Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).swap(slotName);
                AzureMessager.getMessager().info(AzureString.format((String)"Swap deployment slot %s into production successfully", (Object[])new Object[]{slotName}));
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void syncTriggers() {
        Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).ifPresent(com.azure.resourcemanager.appservice.models.FunctionApp::syncTriggers);
    }

    @Nonnull
    public Map<String, String> listFunctionKeys(String functionName) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getFullRemote()).map(r -> r.listFunctionKeys(functionName)).orElseGet(HashMap::new);
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule slots() {
        return this.deploymentModule;
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule getDeploymentModule() {
        return this.deploymentModule;
    }

    static {
        FunctionApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionApp.java", FunctionApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "", "", "", "void"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "", "", "", "void"), 83);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "triggerFunction", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "java.lang.String:java.lang.Object", "functionName:input", "", "void"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "swap", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "java.lang.String", "slotName", "", "void"), 110);
    }
}

