/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceManager;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class FunctionAppDraft
extends FunctionApp
implements AzResource.Draft<FunctionApp, WebSiteBase> {
    private static final String CREATE_NEW_FUNCTION_APP = "isCreateNewFunctionApp";
    public static final String FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    public static final JavaVersion DEFAULT_JAVA_VERSION;
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system of an existing app";
    public static final String APP_SETTING_MACHINEKEY_DECRYPTION_KEY = "MACHINEKEY_DecryptionKey";
    public static final String APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE = "WEBSITES_ENABLE_APP_SERVICE_STORAGE";
    public static final String APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE = "false";
    public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE = "FUNCTION_APP_EDIT_MODE";
    public static final String APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY = "readOnly";
    @Nullable
    private final FunctionApp origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    FunctionAppDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull FunctionAppModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    FunctionAppDraft(@Nonnull FunctionApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Nonnull
    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public com.azure.resourcemanager.appservice.models.FunctionApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            FunctionApp.DefinitionStages.WithCreate withCreate;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getContext().getActionParent().setProperty(CREATE_NEW_FUNCTION_APP, String.valueOf(true));
            String name = this.getName();
            Runtime newRuntime = Objects.requireNonNull(this.getRuntime(), "'runtime' is required to create a Azure Functions app");
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = Objects.requireNonNull(this.getAppServicePlan(), "'service plan' is required to create a Azure Functions app");
            Map<String, String> newAppSettings = this.getAppSettings();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            String funcExtVersion = Optional.ofNullable(newAppSettings).map(map -> (String)map.get(FUNCTIONS_EXTENSION_VERSION)).orElse(null);
            AppServiceManager manager = Objects.requireNonNull((AppServiceManager)((AppServiceResourceManager)this.getParent()).getRemote());
            FunctionApp.DefinitionStages.Blank blank = (FunctionApp.DefinitionStages.Blank)manager.functionApps().define(name);
            if (newRuntime.getOperatingSystem() == OperatingSystem.LINUX) {
                withCreate = blank.withExistingLinuxAppServicePlan((AppServicePlan)newPlan.getRemote()).withExistingResourceGroup(this.getResourceGroupName()).withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(newRuntime, funcExtVersion));
            } else if (newRuntime.getOperatingSystem() == OperatingSystem.WINDOWS) {
                withCreate = (FunctionApp.DefinitionStages.WithCreate)((FunctionApp.DefinitionStages.WithCreate)blank.withExistingAppServicePlan((AppServicePlan)newPlan.getRemote()).withExistingResourceGroup(this.getResourceGroupName())).withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(null);
            } else if (newRuntime.getOperatingSystem() == OperatingSystem.DOCKER) {
                withCreate = this.createDockerApp(blank, newPlan);
            } else {
                throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
            }
            if (MapUtils.isNotEmpty(newAppSettings)) {
                withCreate.withAppSettings(newAppSettings);
            }
            if (Objects.nonNull(newDiagnosticConfig)) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, newDiagnosticConfig);
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Azure Functions app({0})...", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp = (com.azure.resourcemanager.appservice.models.FunctionApp)Objects.requireNonNull((WebSiteBase)this.doModify(() -> (WebSiteBase)withCreate.create(), "Creating"));
            messager.success(AzureString.format((String)"Azure Functions app({0}) is successfully created", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp2 = functionApp;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    FunctionApp.DefinitionStages.WithCreate createDockerApp(@Nonnull FunctionApp.DefinitionStages.Blank blank, @Nonnull com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
        String message = "Docker configuration is required to create a docker based Azure Functions app";
        DockerConfiguration config = Objects.requireNonNull(this.getDockerConfiguration(), "Docker configuration is required to create a docker based Azure Functions app");
        if (StringUtils.equalsIgnoreCase((CharSequence)plan.getPricingTier().getTier(), (CharSequence)"Dynamic")) {
            throw new AzureToolkitRuntimeException("Docker function is not supported in consumption service plan");
        }
        FunctionApp.DefinitionStages.WithDockerContainerImage withLinuxAppFramework = blank.withExistingLinuxAppServicePlan((AppServicePlan)plan.getRemote()).withExistingResourceGroup(this.getResourceGroupName());
        FunctionApp.DefinitionStages.WithCreate draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{config.getUserName(), config.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(config.getImage()) : (StringUtils.isEmpty((CharSequence)config.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(config.getImage()).withCredentials(config.getUserName(), config.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(config.getImage(), config.getRegistryUrl()).withCredentials(config.getUserName(), config.getPassword()));
        String decryptionKey = this.generateDecryptionKey();
        return (FunctionApp.DefinitionStages.WithCreate)draft.withAppSetting(APP_SETTING_MACHINEKEY_DECRYPTION_KEY, decryptionKey).withAppSetting(APP_SETTING_WEBSITES_ENABLE_APP_SERVICE_STORAGE, APP_SETTING_DISABLE_WEBSITES_APP_SERVICE_STORAGE).withAppSetting(APP_SETTING_FUNCTION_APP_EDIT_MODE, APP_SETTING_FUNCTION_APP_EDIT_MODE_READONLY);
    }

    protected String generateDecryptionKey() {
        return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
    }

    @Nonnull
    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public com.azure.resourcemanager.appservice.models.FunctionApp updateResourceInAzure(@Nonnull WebSiteBase base) {
        WebSiteBase webSiteBase = base;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)webSiteBase);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            com.azure.resourcemanager.appservice.models.FunctionApp remote = (com.azure.resourcemanager.appservice.models.FunctionApp)base;
            assert (this.origin != null) : "updating target is not specified.";
            Map<String, String> settingsToAdd = this.getAppSettings();
            Set<String> settingsToRemove = this.getAppSettingsToRemove();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            Runtime newRuntime = this.getRuntime();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan = this.getAppServicePlan();
            DockerConfiguration newDockerConfig = this.getDockerConfiguration();
            Runtime oldRuntime = Objects.requireNonNull(this.origin.getRuntime());
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan oldPlan = this.origin.getAppServicePlan();
            boolean planModified = Objects.nonNull((Object)newPlan) && !Objects.equals((Object)newPlan, (Object)oldPlan);
            boolean runtimeModified = !oldRuntime.isDocker() && Objects.nonNull(newRuntime) && !Objects.equals(newRuntime, oldRuntime);
            boolean dockerModified = oldRuntime.isDocker() && Objects.nonNull(newDockerConfig);
            boolean modified = planModified || runtimeModified || dockerModified || MapUtils.isNotEmpty(settingsToAdd) || CollectionUtils.isNotEmpty(settingsToRemove) || Objects.nonNull(newDiagnosticConfig);
            String funcExtVersion = Optional.ofNullable(settingsToAdd).map(map -> (String)map.get(FUNCTIONS_EXTENSION_VERSION)).orElse(null);
            if (modified) {
                FunctionApp.Update update = (FunctionApp.Update)remote.update();
                Optional.ofNullable(newPlan).ifPresent(p -> this.updateAppServicePlan(update, (com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan)((Object)p)));
                Optional.ofNullable(newRuntime).ifPresent(p -> this.updateRuntime(update, (Runtime)p, funcExtVersion));
                Optional.ofNullable(settingsToAdd).ifPresent(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0));
                Optional.ofNullable(settingsToRemove).ifPresent(s -> s.forEach(arg_0 -> ((FunctionApp.Update)update).withoutAppSetting(arg_0)));
                Optional.ofNullable(newDockerConfig).ifPresent(p -> this.updateDockerConfiguration(update, (DockerConfiguration)p));
                Optional.ofNullable(newDiagnosticConfig).ifPresent(c -> AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, newDiagnosticConfig));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating Azure Functions App({0})...", (Object[])new Object[]{remote.name()}));
                remote = (com.azure.resourcemanager.appservice.models.FunctionApp)update.apply();
                messager.success(AzureString.format((String)"Azure Functions App({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp = remote;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void updateAppServicePlan(@Nonnull FunctionApp.Update update, @Nonnull com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan newPlan) {
        Objects.requireNonNull((AppServicePlan)newPlan.getRemote(), "Target app service plan doesn't exist");
        update.withExistingAppServicePlan((AppServicePlan)newPlan.getRemote());
    }

    private void updateRuntime(@Nonnull FunctionApp.Update update, @Nonnull Runtime newRuntime, String funcExtVersion) {
        Runtime oldRuntime = Objects.requireNonNull(Objects.requireNonNull(this.origin).getRuntime());
        if (newRuntime.getOperatingSystem() != null && oldRuntime.getOperatingSystem() != newRuntime.getOperatingSystem()) {
            throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
        }
        OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), oldRuntime.getOperatingSystem()}));
        if (operatingSystem == OperatingSystem.LINUX) {
            update.withBuiltInImage(AppServiceUtils.toFunctionRuntimeStack(newRuntime, funcExtVersion));
        } else if (operatingSystem == OperatingSystem.WINDOWS) {
            if (Objects.equals(oldRuntime.getJavaVersion(), JavaVersion.OFF)) {
                JavaVersion javaVersion = Optional.ofNullable(newRuntime.getJavaVersion()).orElse(DEFAULT_JAVA_VERSION);
                update.withJavaVersion(AppServiceUtils.toJavaVersion(javaVersion)).withWebContainer(null);
            } else if (ObjectUtils.notEqual((Object)newRuntime.getJavaVersion(), (Object)JavaVersion.OFF) && ObjectUtils.notEqual((Object)newRuntime.getJavaVersion(), (Object)oldRuntime.getJavaVersion())) {
                update.withJavaVersion(AppServiceUtils.toJavaVersion(newRuntime.getJavaVersion())).withWebContainer(null);
            }
        } else {
            if (newRuntime.getOperatingSystem() == OperatingSystem.DOCKER) {
                return;
            }
            throw new AzureToolkitRuntimeException(String.format(UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    private void updateDockerConfiguration(@Nonnull FunctionApp.Update update, @Nonnull DockerConfiguration newConfig) {
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{newConfig.getUserName(), newConfig.getPassword()})) {
            update.withPublicDockerHubImage(newConfig.getImage());
        } else if (StringUtils.isEmpty((CharSequence)newConfig.getRegistryUrl())) {
            update.withPrivateDockerHubImage(newConfig.getImage()).withCredentials(newConfig.getUserName(), newConfig.getPassword());
        } else {
            update.withPrivateRegistryImage(newConfig.getImage(), newConfig.getRegistryUrl()).withCredentials(newConfig.getUserName(), newConfig.getPassword());
        }
    }

    public void setRuntime(Runtime runtime) {
        this.ensureConfig().setRuntime(runtime);
    }

    @Override
    @Nullable
    public Runtime getRuntime() {
        return Optional.ofNullable(this.config).map(Config::getRuntime).orElseGet(() -> super.getRuntime());
    }

    public void setAppServicePlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
        this.ensureConfig().setPlan(plan);
    }

    @Override
    @Nullable
    public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getAppServicePlan() {
        return Optional.ofNullable(this.config).map(Config::getPlan).orElseGet(() -> super.getAppServicePlan());
    }

    public void setDiagnosticConfig(DiagnosticConfig config) {
        this.ensureConfig().setDiagnosticConfig(config);
    }

    @Override
    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.config).map(Config::getDiagnosticConfig).orElseGet(() -> super.getDiagnosticConfig());
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.ensureConfig().setAppSettings(appSettings);
    }

    public void setAppSetting(String key, String value) {
        this.ensureConfig().getAppSettings().put(key, value);
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.config).map(Config::getAppSettings).orElseGet(() -> super.getAppSettings());
    }

    public void removeAppSetting(String key) {
        this.ensureConfig().getAppSettingsToRemove().add(key);
    }

    @Nullable
    public Set<String> getAppSettingsToRemove() {
        return Optional.ofNullable(this.config).map(Config::getAppSettingsToRemove).orElse(new HashSet());
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.ensureConfig().setDockerConfiguration(dockerConfiguration);
    }

    @Nullable
    public DockerConfiguration getDockerConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getDockerConfiguration).orElse(null);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRuntime()) || Objects.equals(this.config.getRuntime(), super.getRuntime()) || Objects.isNull((Object)this.config.getPlan()) || Objects.equals((Object)this.config.getPlan(), (Object)super.getAppServicePlan()) || Objects.isNull(this.config.getDiagnosticConfig()) || CollectionUtils.isEmpty(this.config.getAppSettingsToRemove()) || Objects.isNull(this.config.getAppSettings()) || Objects.equals(this.config.getAppSettings(), super.getAppSettings()) || Objects.isNull(this.config.getDockerConfiguration());
        return !notModified;
    }

    @Nullable
    public FunctionApp getOrigin() {
        return this.origin;
    }

    static {
        FunctionAppDraft.ajc$preClinit();
        DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppDraft.java", FunctionAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft", "", "", "", "com.azure.resourcemanager.appservice.models.FunctionApp"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDraft", "com.azure.resourcemanager.appservice.models.WebSiteBase", "base", "", "com.azure.resourcemanager.appservice.models.FunctionApp"), 171);
    }

    @Nullable
    private static class Config {
        private Runtime runtime;
        private com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan = null;
        private DiagnosticConfig diagnosticConfig = null;
        private Set<String> appSettingsToRemove = new HashSet<String>();
        private Map<String, String> appSettings = new HashMap<String, String>();
        private DockerConfiguration dockerConfiguration = null;

        public Runtime getRuntime() {
            return this.runtime;
        }

        public com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan getPlan() {
            return this.plan;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }

        public Set<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public DockerConfiguration getDockerConfiguration() {
            return this.dockerConfiguration;
        }

        public void setRuntime(Runtime runtime) {
            this.runtime = runtime;
        }

        public void setPlan(com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan plan) {
            this.plan = plan;
        }

        public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
        }

        public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
        }

        public void setAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
        }

        public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = dockerConfiguration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Runtime this$runtime = this.getRuntime();
            Runtime other$runtime = other.getRuntime();
            if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
                return false;
            }
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan this$plan = this.getPlan();
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !((Object)((Object)this$plan)).equals((Object)other$plan)) {
                return false;
            }
            DiagnosticConfig this$diagnosticConfig = this.getDiagnosticConfig();
            DiagnosticConfig other$diagnosticConfig = other.getDiagnosticConfig();
            if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
                return false;
            }
            Set<String> this$appSettingsToRemove = this.getAppSettingsToRemove();
            Set<String> other$appSettingsToRemove = other.getAppSettingsToRemove();
            if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
                return false;
            }
            Map<String, String> this$appSettings = this.getAppSettings();
            Map<String, String> other$appSettings = other.getAppSettings();
            if (this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings)) {
                return false;
            }
            DockerConfiguration this$dockerConfiguration = this.getDockerConfiguration();
            DockerConfiguration other$dockerConfiguration = other.getDockerConfiguration();
            return !(this$dockerConfiguration == null ? other$dockerConfiguration != null : !((Object)this$dockerConfiguration).equals(other$dockerConfiguration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Runtime $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
            com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : ((Object)((Object)$plan)).hashCode());
            DiagnosticConfig $diagnosticConfig = this.getDiagnosticConfig();
            result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
            Set<String> $appSettingsToRemove = this.getAppSettingsToRemove();
            result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
            Map<String, String> $appSettings = this.getAppSettings();
            result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
            DockerConfiguration $dockerConfiguration = this.getDockerConfiguration();
            result = result * 59 + ($dockerConfiguration == null ? 43 : ((Object)$dockerConfiguration).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppDraft.Config(runtime=" + this.getRuntime() + ", plan=" + (Object)((Object)this.getPlan()) + ", diagnosticConfig=" + this.getDiagnosticConfig() + ", appSettingsToRemove=" + this.getAppSettingsToRemove() + ", appSettings=" + this.getAppSettings() + ", dockerConfiguration=" + this.getDockerConfiguration() + ")";
        }
    }
}

