/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.file;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.KuduAuthenticationPolicy;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AppServiceKuduClient
implements IFileClient,
IProcessClient {
    private final String host;
    private final KuduService kuduService;
    private final AppServiceAppBase<?, ?, ?> app;

    private AppServiceKuduClient(String host, KuduService kuduService, AppServiceAppBase<?, ?, ?> app) {
        this.host = host;
        this.app = app;
        this.kuduService = kuduService;
    }

    public static AppServiceKuduClient getClient(@Nonnull WebAppBase webAppBase, @Nonnull AppServiceAppBase<?, ?, ?> appService) {
        if (webAppBase.defaultHostname() == null) {
            throw new AzureToolkitRuntimeException("Cannot initialize kudu client before web app is created");
        }
        String host = webAppBase.defaultHostname().toLowerCase(Locale.ROOT).replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = parts[0] + ".scm." + parts[1];
        host = "https://" + host;
        List<HttpPipelinePolicy> policies = Utils.getPolicyFromPipeline(((AppServiceManager)webAppBase.manager()).httpPipeline(), policy -> !(policy instanceof AuthenticationPolicy) && !(policy instanceof ProviderRegistrationPolicy) && !(policy instanceof AuxiliaryAuthenticationPolicy));
        policies.add((HttpPipelinePolicy)new KuduAuthenticationPolicy(webAppBase));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(((AppServiceManager)webAppBase.manager()).httpPipeline().getHttpClient()).build();
        KuduService kuduService = (KuduService)RestProxy.create(KuduService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
        return new AppServiceKuduClient(host, kuduService, appService);
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        return this.kuduService.getFileContent(this.host, path).flatMapMany(StreamResponse::getValue);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return ((List)((Response)this.kuduService.getFilesInDirectory(this.host, dir).block()).getValue()).stream().filter(file -> !"text/xml".equals(file.getMime()) || !file.getName().contains("LogFiles-kudu-trace_pending.xml")).map(file -> file.withApp(this.app).withPath(Paths.get(dir, file.getName()).toString())).collect(Collectors.toList());
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        File file = new File(path);
        List<? extends AppServiceFile> result = this.getFilesInDirectory(file.getParent());
        return result.stream().filter(appServiceFile -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)appServiceFile.getName())).findFirst().orElse(null);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.kuduService.saveFile(this.host, path, content).block();
    }

    @Override
    public void createDirectory(String path) {
        this.kuduService.createDirectory(this.host, path).block();
    }

    @Override
    public void deleteFile(String path) {
        this.kuduService.deleteFile(this.host, path).block();
    }

    @Override
    public List<ProcessInfo> listProcess() {
        return (List)((Response)this.kuduService.listProcess(this.host).block()).getValue();
    }

    @Override
    public CommandOutput execute(String command, String dir) {
        Object commandRequest = ((CommandRequest.CommandRequestBuilder)((CommandRequest.CommandRequestBuilder)CommandRequest.builder().command(command)).dir(dir)).build();
        return (CommandOutput)((Response)this.kuduService.execute(this.host, JsonUtils.toJson(commandRequest)).block()).getValue();
    }

    @Override
    public TunnelStatus getAppServiceTunnelStatus() {
        return (TunnelStatus)((Response)this.kuduService.getAppServiceTunnelStatus(this.host).block()).getValue();
    }

    public static class CommandRequest {
        private String command;
        private String dir;

        protected CommandRequest(CommandRequestBuilder<?, ?> b) {
            this.command = ((CommandRequestBuilder)b).command;
            this.dir = ((CommandRequestBuilder)b).dir;
        }

        public static CommandRequestBuilder<?, ?> builder() {
            return new CommandRequestBuilderImpl();
        }

        public CommandRequestBuilder<?, ?> toBuilder() {
            return new CommandRequestBuilderImpl().$fillValuesFrom(this);
        }

        public String getCommand() {
            return this.command;
        }

        public String getDir() {
            return this.dir;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandRequest)) {
                return false;
            }
            CommandRequest other = (CommandRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$dir = this.getDir();
            String other$dir = other.getDir();
            return !(this$dir == null ? other$dir != null : !this$dir.equals(other$dir));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
            return result;
        }

        public String toString() {
            return "AppServiceKuduClient.CommandRequest(command=" + this.getCommand() + ", dir=" + this.getDir() + ")";
        }

        private static final class CommandRequestBuilderImpl
        extends CommandRequestBuilder<CommandRequest, CommandRequestBuilderImpl> {
            private CommandRequestBuilderImpl() {
            }

            @Override
            protected CommandRequestBuilderImpl self() {
                return this;
            }

            @Override
            public CommandRequest build() {
                return new CommandRequest(this);
            }
        }

        public static abstract class CommandRequestBuilder<C extends CommandRequest, B extends CommandRequestBuilder<C, B>> {
            private String command;
            private String dir;

            protected B $fillValuesFrom(C instance) {
                CommandRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            private static void $fillValuesFromInstanceIntoBuilder(CommandRequest instance, CommandRequestBuilder<?, ?> b) {
                b.command(instance.command);
                b.dir(instance.dir);
            }

            protected abstract B self();

            public abstract C build();

            public B command(String command) {
                this.command = command;
                return this.self();
            }

            public B dir(String dir) {
                this.dir = dir;
                return this.self();
            }

            public String toString() {
                return "AppServiceKuduClient.CommandRequest.CommandRequestBuilder(command=" + this.command + ", dir=" + this.dir + ")";
            }
        }
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KuduService")
    private static interface KuduService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="api/vfs/{path}")
        public Mono<StreamResponse> getFileContent(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="api/vfs/{path}/")
        public Mono<Response<List<AppServiceFile>>> getFilesInDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/octet-stream; charset=utf-8", "If-Match: *"})
        @Put(value="api/vfs/{path}")
        public Mono<Void> saveFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2, @BodyParam(value="application/octet-stream") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Put(value="api/vfs/{path}/")
        public Mono<Void> createDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "If-Match: *"})
        @Delete(value="api/vfs/{path}")
        public Mono<Void> deleteFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"x-ms-body-logging: false"})
        @Get(value="api/processes")
        public Mono<Response<List<ProcessInfo>>> listProcess(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Post(value="api/command")
        public Mono<Response<CommandOutput>> execute(@HostParam(value="$host") String var1, @BodyParam(value="json") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Get(value="AppServiceTunnel/Tunnel.ashx?GetStatus&GetStatusAPIVer=2")
        public Mono<Response<TunnelStatus>> getAppServiceTunnelStatus(@HostParam(value="$host") String var1);
    }
}

