/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceManager;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureAppService
extends AbstractAzService<AppServiceResourceManager, AppServiceManager> {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AzureAppService() {
        super("Microsoft.Web");
    }

    @Nonnull
    public FunctionAppModule functionApps(@Nonnull String subscriptionId) {
        AppServiceResourceManager rm = (AppServiceResourceManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getFunctionAppModule();
    }

    @Nonnull
    public List<FunctionApp> functionApps() {
        return this.list().stream().flatMap(m -> m.functionApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public FunctionApp functionApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (FunctionApp)this.functionApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    public WebAppModule webApps(@Nonnull String subscriptionId) {
        AppServiceResourceManager rm = (AppServiceResourceManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getWebAppModule();
    }

    @Nonnull
    public List<WebApp> webApps() {
        return this.list().stream().flatMap(m -> m.webApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public WebApp webApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (WebApp)this.webApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    public AppServicePlanModule plans(@Nonnull String subscriptionId) {
        AppServiceResourceManager rm = (AppServiceResourceManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getPlanModule();
    }

    @Nonnull
    public List<AppServicePlan> plans() {
        return this.list().stream().flatMap(m -> m.plans().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public AppServicePlan plan(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (AppServicePlan)this.plans(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    protected AppServiceManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        return ((AppServiceManager.Configurable)((AppServiceManager.Configurable)((AppServiceManager.Configurable)AppServiceManager.configure().withHttpClient(AbstractAzResourceManager.getDefaultHttpClient())).withLogLevel(logLevel)).withPolicy(AbstractAzResourceManager.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    protected AppServiceResourceManager newResource(@Nonnull AppServiceManager remote) {
        return new AppServiceResourceManager(remote, this);
    }

    @Nonnull
    @AzureOperation(name="webapp.list_runtimes.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.SERVICE)
    public List<Runtime> listWebAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.WEBAPP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="function.list_runtimes.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.SERVICE)
    public List<Runtime> listFunctionAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.FUNCTION_APP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public <E> E getById(@Nonnull String id) {
        boolean isFunctionRelated;
        block4: {
            ResourceId resourceId = ResourceId.fromString((String)id);
            if (resourceId.resourceType().equals("serverfarms")) {
                return (E)super.doGetById(id);
            }
            isFunctionRelated = false;
            try {
                isFunctionRelated = Optional.ofNullable((AppServiceResourceManager)this.get(resourceId.subscriptionId(), null)).map(AbstractAzResource::getRemote).map(r -> r.resourceManager().genericResources().getById(id)).filter(r -> StringUtils.containsIgnoreCase((CharSequence)r.kind(), (CharSequence)"function")).isPresent();
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block4;
                throw e;
            }
        }
        if (isFunctionRelated) {
            return (E)((AzureFunctions)Azure.az(AzureFunctions.class)).doGetById(id);
        }
        return (E)((AzureWebApp)Azure.az(AzureWebApp.class)).doGetById(id);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "App Services";
    }

    static {
        AzureAppService.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAppService.java", AzureAppService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listWebAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listFunctionAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 132);
    }
}

