/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.ResourceNameAvailabilityInner;
import com.azure.resourcemanager.appservice.models.CheckNameResourceTypes;
import com.azure.resourcemanager.appservice.models.ResourceNameAvailabilityRequest;
import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AppServiceResourceManager
extends AbstractAzResourceManager<AppServiceResourceManager, AppServiceManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final FunctionAppModule functionAppModule;
    @Nonnull
    private final WebAppModule webAppModule;
    @Nonnull
    private final AppServicePlanModule planModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected AppServiceResourceManager(@Nonnull String subscriptionId, @Nonnull AzureAppService service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.functionAppModule = new FunctionAppModule(this);
        this.webAppModule = new WebAppModule(this);
        this.planModule = new AppServicePlanModule(this);
    }

    protected AppServiceResourceManager(@Nonnull AppServiceManager remote, @Nonnull AzureAppService service) {
        this(remote.subscriptionId(), service);
        this.setRemote(remote);
    }

    @Nonnull
    public List<AzResourceModule<?, AppServiceResourceManager, ?>> getSubModules() {
        return Arrays.asList(new AzResourceModule[]{this.webAppModule, this.functionAppModule, this.planModule});
    }

    @Nonnull
    public FunctionAppModule functionApps() {
        return this.functionAppModule;
    }

    @Nonnull
    public AppServicePlanModule plans() {
        return this.planModule;
    }

    @Nonnull
    public WebAppModule webApps() {
        return this.webAppModule;
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((AppServiceManager)this.getRemote()).resourceManager();
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.webAppModule.getName());
    }

    @AzureOperation(name="appservice.check_name.app", params={"name"}, type=AzureOperation.Type.SERVICE)
    public Availability checkNameAvailability(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceNameAvailabilityInner result = ((WebSiteManagementClient)((AppServiceManager)Objects.requireNonNull((AppServiceManager)this.getRemote()).webApps().manager()).serviceClient()).getResourceProviders().checkNameAvailability(new ResourceNameAvailabilityRequest().withName(name).withType(CheckNameResourceTypes.MICROSOFT_WEB_SITES));
            Availability availability = new Availability(result.nameAvailable().booleanValue(), result.reason().toString(), result.message());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return availability;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public FunctionAppModule getFunctionAppModule() {
        return this.functionAppModule;
    }

    @Nonnull
    public WebAppModule getWebAppModule() {
        return this.webAppModule;
    }

    @Nonnull
    public AppServicePlanModule getPlanModule() {
        return this.planModule;
    }

    static {
        AppServiceResourceManager.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServiceResourceManager.java", AppServiceResourceManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkNameAvailability", "com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceManager", "java.lang.String", "name", "", "com.microsoft.azure.toolkit.lib.common.model.Availability"), 86);
    }
}

