/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.PublishingProfileFormat;
import com.azure.resourcemanager.appservice.models.SupportsOneDeploy;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.file.AppServiceKuduClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Startable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class AppServiceAppBase<T extends AppServiceAppBase<T, P, F>, P extends AbstractAzResource<P, ?, ?>, F extends WebAppBase>
extends AbstractAzResource<T, P, WebSiteBase>
implements Startable,
Deletable {
    private static final Logger log;
    protected AppServiceKuduClient kuduManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected AppServiceAppBase(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, WebSiteBase> module) {
        super(name, resourceGroupName, module);
    }

    protected AppServiceAppBase(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, WebSiteBase> module) {
        super(name, module);
    }

    protected AppServiceAppBase(@Nonnull T origin) {
        super(origin);
        this.kuduManager = ((AppServiceAppBase)((Object)origin)).kuduManager;
    }

    @Nullable
    protected WebSiteBase refreshRemote(@Nonnull WebSiteBase remote) {
        return (WebSiteBase)super.loadRemote();
    }

    @Nullable
    public synchronized F getFullRemote() {
        WebSiteBase remote = (WebSiteBase)this.getRemote();
        if (!(remote instanceof WebAppBase)) {
            this.reload();
            remote = (WebSiteBase)this.getRemote();
        }
        return (F)((WebAppBase)remote);
    }

    @AzureOperation(name="appservice.start.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getFullRemote())).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice.stop.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getFullRemote())).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice.restart.app", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> ((WebAppBase)Objects.requireNonNull(this.getFullRemote())).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void deploy(@Nonnull DeployType deployType, @Nonnull File targetFile, @Nullable String targetPath) {
        WebSiteBase remote = (WebSiteBase)this.getRemote();
        if (remote instanceof SupportsOneDeploy) {
            DeployOptions options = new DeployOptions().withPath(targetPath);
            AzureMessager.getMessager().info(AzureString.format((String)"Deploying (%s)[%s] %s ...", (Object[])new Object[]{targetFile.toString(), deployType.toString(), StringUtils.isBlank((CharSequence)targetPath) ? "" : " to " + targetPath}));
            com.azure.resourcemanager.appservice.models.DeployType type = com.azure.resourcemanager.appservice.models.DeployType.fromString((String)deployType.getValue());
            this.doModify(() -> Objects.requireNonNull((SupportsOneDeploy)remote).deploy(type, targetFile, options), "Deploying");
        }
    }

    @Nullable
    public String getHostName() {
        return this.remoteOptional().map(WebSiteBase::defaultHostname).orElse(null);
    }

    @Nullable
    public String getLinuxFxVersion() {
        return Optional.ofNullable(this.getFullRemote()).map(WebAppBase::linuxFxVersion).orElse(null);
    }

    @Nullable
    public PublishingProfile getPublishingProfile() {
        return Optional.ofNullable(this.getFullRemote()).map(WebAppBase::getPublishingProfile).map(AppServiceUtils::fromPublishingProfile).orElse(null);
    }

    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.getFullRemote()).map(WebAppBase::diagnosticLogsConfig).map(AppServiceUtils::fromWebAppDiagnosticLogs).orElse(null);
    }

    @Nonnull
    public Flux<String> streamAllLogsAsync() {
        return Optional.ofNullable(this.getFullRemote()).map(WebAppBase::streamAllLogsAsync).orElseGet(Flux::empty);
    }

    @Nonnull
    public Flux<ByteBuffer> getFileContent(String path) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFileContent(path)).orElseGet(Flux::empty);
    }

    @Nonnull
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFilesInDirectory(dir)).orElseGet(Collections::emptyList);
    }

    @Nullable
    public AppServiceFile getFileByPath(String path) {
        return Optional.ofNullable(this.getFileClient()).map(c -> c.getFileByPath(path)).orElse(null);
    }

    public void uploadFileToPath(String content, String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.uploadFileToPath(content, path));
    }

    public void createDirectory(String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.createDirectory(path));
    }

    public void deleteFile(String path) {
        Optional.ofNullable(this.getFileClient()).ifPresent(c -> c.deleteFile(path));
    }

    @Nonnull
    public List<ProcessInfo> listProcess() {
        return Optional.ofNullable(this.getProcessClient()).map(IProcessClient::listProcess).orElseGet(Collections::emptyList);
    }

    @Nullable
    public CommandOutput execute(String command, String dir) {
        return Optional.ofNullable(this.getProcessClient()).map(c -> c.execute(command, dir)).orElse(null);
    }

    public InputStream listPublishingProfileXmlWithSecrets() {
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String resourceName = StringUtils.equals((CharSequence)resourceId.resourceType(), (CharSequence)"slots") ? String.format("%s/slots/%s", resourceId.parent().name(), resourceId.name()) : resourceId.name();
        CsmPublishingProfileOptions csmPublishingProfileOptions = new CsmPublishingProfileOptions().withFormat(PublishingProfileFormat.FTP);
        return ((WebSiteManagementClient)((AppServiceManager)((WebAppBase)Objects.requireNonNull(this.getFullRemote())).manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecrets(resourceId.resourceGroupName(), resourceName, csmPublishingProfileOptions);
    }

    @Nullable
    public TunnelStatus getAppServiceTunnelStatus() {
        return Optional.ofNullable(this.getProcessClient()).map(IProcessClient::getAppServiceTunnelStatus).orElse(null);
    }

    @Nullable
    public AppServicePlan getAppServicePlan() {
        AppServicePlanModule plans = ((AzureAppService)Azure.az(AzureAppService.class)).plans(this.getSubscriptionId());
        return this.remoteOptional().map(WebSiteBase::appServicePlanId).map(arg_0 -> ((AppServicePlanModule)plans).get(arg_0)).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(Resource::regionName).map(Region::fromName).orElse(null);
    }

    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.getFullRemote()).map(WebAppBase::getAppSettings).map(Utils::normalizeAppSettings).orElse(null);
    }

    @Nullable
    public Runtime getRuntime() {
        return Optional.ofNullable(this.getFullRemote()).map(AppServiceUtils::getRuntimeFromAppService).orElse(null);
    }

    @Nonnull
    public String loadStatus(@Nonnull WebSiteBase remote) {
        return remote.state();
    }

    @Nullable
    protected IFileClient getFileClient() {
        return this.getKuduManager();
    }

    @Nullable
    protected IProcessClient getProcessClient() {
        return this.getKuduManager();
    }

    @Nullable
    protected AppServiceKuduClient getKuduManager() {
        if (this.kuduManager == null) {
            this.kuduManager = Optional.ofNullable(this.getFullRemote()).map(r -> AppServiceKuduClient.getClient(r, this)).orElse(null);
        }
        return this.kuduManager;
    }

    static {
        AppServiceAppBase.ajc$preClinit();
        log = LoggerFactory.getLogger(AppServiceAppBase.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServiceAppBase.java", AppServiceAppBase.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 99);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 104);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase", "", "", "", "void"), 109);
    }
}

