/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationInsight
extends AbstractAzResource<ApplicationInsight, ApplicationInsightsServiceSubscription, ApplicationInsightsComponent>
implements Deletable {
    public static final Action.Id<ApplicationInsight> OPEN_LIVE_METRICS = Action.Id.of((String)"user/ai.open_live_metrics.ai");
    public static final Action.Id<ApplicationInsight> COPY_CONNECTION_STRING = Action.Id.of((String)"user/ai.copy_connection_string.ai");

    protected ApplicationInsight(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ApplicationInsightsModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
    }

    protected ApplicationInsight(@Nonnull ApplicationInsight insight) {
        super((AbstractAzResource)insight);
    }

    protected ApplicationInsight(@Nonnull ApplicationInsightsComponent remote, @Nonnull ApplicationInsightsModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
    }

    @Nullable
    public Region getRegion() {
        return Optional.ofNullable((ApplicationInsightsComponent)this.getRemote()).map(component -> Region.fromName((String)component.regionName())).orElse(null);
    }

    @Nullable
    public String getType() {
        return Optional.ofNullable((ApplicationInsightsComponent)this.getRemote()).map(ApplicationInsightsComponent::type).orElse(null);
    }

    @Nullable
    public String getKind() {
        return Optional.ofNullable((ApplicationInsightsComponent)this.getRemote()).map(ApplicationInsightsComponent::kind).orElse(null);
    }

    @Nullable
    public String getInstrumentationKey() {
        return Optional.ofNullable((ApplicationInsightsComponent)this.getRemote()).map(ApplicationInsightsComponent::instrumentationKey).orElse(null);
    }

    public String getConnectionString() {
        return Optional.ofNullable((ApplicationInsightsComponent)this.getRemote()).map(ApplicationInsightsComponent::connectionString).orElse(null);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull ApplicationInsightsComponent remote) {
        return remote.provisioningState();
    }
}

