/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.AzureApplicationInsights;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ApplicationInsightsServiceSubscription
extends AbstractAzServiceSubscription<ApplicationInsightsServiceSubscription, ApplicationInsightsManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final ApplicationInsightsModule applicationInsightsModule;

    protected ApplicationInsightsServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureApplicationInsights service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.applicationInsightsModule = new ApplicationInsightsModule(this);
    }

    protected ApplicationInsightsServiceSubscription(@Nonnull ApplicationInsightsManager manager, @Nonnull AzureApplicationInsights service) {
        this(manager.serviceClient().getSubscriptionId(), service);
    }

    @Nonnull
    public ApplicationInsightsModule applicationInsights() {
        return this.applicationInsightsModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ApplicationInsightsServiceSubscription, ?>> getSubModules() {
        return Collections.singletonList(this.applicationInsightsModule);
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.applicationInsightsModule.getName());
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public ApplicationInsightsModule getApplicationInsightsModule() {
        return this.applicationInsightsModule;
    }
}

