/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.TableEncryptionPolicy;
import com.microsoft.azure.storage.table.TablePayloadFormat;

public class TableRequestOptions
extends RequestOptions {
    private PropertyResolver propertyResolver;
    private TablePayloadFormat payloadFormat;
    private Boolean dateBackwardCompatibility;
    private TableEncryptionPolicy encryptionPolicy;
    private EncryptionResolver encryptionResolver;

    public TableRequestOptions() {
    }

    public TableRequestOptions(TableRequestOptions other) {
        super(other);
        if (other != null) {
            this.setTablePayloadFormat(other.getTablePayloadFormat());
            this.setPropertyResolver(other.getPropertyResolver());
            this.setDateBackwardCompatibility(other.getDateBackwardCompatibility());
            this.setEncryptionPolicy(other.getEncryptionPolicy());
            this.setEncryptionResolver(other.getEncryptionResolver());
        }
    }

    protected static final TableRequestOptions populateAndApplyDefaults(TableRequestOptions options, CloudTableClient client) {
        TableRequestOptions modifiedOptions = new TableRequestOptions(options);
        TableRequestOptions.populate(modifiedOptions, client.getDefaultRequestOptions());
        TableRequestOptions.applyDefaults(modifiedOptions);
        return modifiedOptions;
    }

    protected static void applyDefaults(TableRequestOptions modifiedOptions) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(TablePayloadFormat.Json);
        }
        if (modifiedOptions.getDateBackwardCompatibility() == null) {
            modifiedOptions.setDateBackwardCompatibility(false);
        }
    }

    private static void populate(TableRequestOptions modifiedOptions, TableRequestOptions clientOptions) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, true);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(clientOptions.getTablePayloadFormat());
        }
        if (modifiedOptions.getPropertyResolver() == null) {
            modifiedOptions.setPropertyResolver(clientOptions.getPropertyResolver());
        }
        if (modifiedOptions.getDateBackwardCompatibility() == null) {
            modifiedOptions.setDateBackwardCompatibility(clientOptions.getDateBackwardCompatibility());
        }
        if (modifiedOptions.getEncryptionPolicy() == null) {
            modifiedOptions.setEncryptionPolicy(clientOptions.getEncryptionPolicy());
        }
        if (modifiedOptions.getEncryptionResolver() == null) {
            modifiedOptions.setEncryptionResolver(clientOptions.getEncryptionResolver());
        }
    }

    public TablePayloadFormat getTablePayloadFormat() {
        return this.payloadFormat;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public Boolean getDateBackwardCompatibility() {
        return this.dateBackwardCompatibility;
    }

    public TableEncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public EncryptionResolver getEncryptionResolver() {
        return this.encryptionResolver;
    }

    public void setTablePayloadFormat(TablePayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public void setDateBackwardCompatibility(Boolean dateBackwardCompatibility) {
        this.dateBackwardCompatibility = dateBackwardCompatibility;
    }

    public void setEncryptionPolicy(TableEncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public void setEncryptionResolver(EncryptionResolver encryptionResolver) {
        this.encryptionResolver = encryptionResolver;
    }

    protected void assertNoEncryptionPolicyOrStrictMode() {
        if (this.getEncryptionPolicy() != null) {
            throw new IllegalArgumentException("Encryption is not supported for the current operation. Please ensure that EncryptionPolicy is not set on RequestOptions.");
        }
        this.assertPolicyIfRequired();
    }

    protected void assertPolicyIfRequired() {
        if (this.requireEncryption() != null && this.requireEncryption().booleanValue() && this.getEncryptionPolicy() == null) {
            throw new IllegalArgumentException("Encryption Policy is mandatory when RequireEncryption is set to true. If you do not want to encrypt/decrypt data, please set RequireEncryption to false in request options.");
        }
    }

    public static interface EncryptionResolver {
        public boolean encryptionResolver(String var1, String var2, String var3);
    }

    public static interface PropertyResolver {
        public EdmType propertyResolver(String var1, String var2, String var3, String var4);
    }
}

