/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.ServiceStats;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.ODataPayload;
import com.microsoft.azure.storage.table.TableDeserializer;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableQuery;
import com.microsoft.azure.storage.table.TableRequest;
import com.microsoft.azure.storage.table.TableRequestOptions;
import com.microsoft.azure.storage.table.TableResponse;
import com.microsoft.azure.storage.table.TableServiceEntity;
import com.microsoft.azure.storage.table.TableServiceException;
import com.microsoft.azure.storage.table.TableStorageErrorDeserializer;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;

public final class CloudTableClient
extends ServiceClient {
    private TableRequestOptions defaultRequestOptions = new TableRequestOptions();
    private final EntityResolver<String> tableNameResolver = new EntityResolver<String>(){

        @Override
        public String resolve(String partitionKey, String rowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
            return properties.get("TableName").getValueAsString();
        }
    };

    public CloudTableClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudTableClient(StorageUri baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        if (credentials == null || credentials.getClass().equals(StorageCredentialsAnonymous.class)) {
            throw new IllegalArgumentException("StorageCredentials cannot be null or anonymous for this service.");
        }
        TableRequestOptions.applyDefaults(this.defaultRequestOptions);
    }

    public CloudTable getTableReference(String tableName) throws URISyntaxException, StorageException {
        return new CloudTable(tableName, this);
    }

    @DoesServiceRequest
    public Iterable<String> listTables() {
        return this.listTables(null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix) {
        return this.listTables(prefix, null, null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix, TableRequestOptions options, OperationContext opContext) {
        return this.generateIteratorForQuery(this.generateListTablesQuery(prefix), this.tableNameResolver, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented() throws StorageException {
        return this.listTablesSegmented(null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix) throws StorageException {
        return this.listTablesSegmented(prefix, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix, Integer maxResults, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (null != maxResults) {
            Utility.assertGreaterThanOrEqual("maxResults", maxResults.intValue(), 1L);
        }
        return this.executeQuerySegmentedImpl(this.generateListTablesQuery(prefix).take(maxResults), this.tableNameResolver, continuationToken, options, opContext);
    }

    private TableQuery<TableServiceEntity> generateListTablesQuery(String prefix) {
        TableQuery<TableServiceEntity> listQuery = TableQuery.from(TableServiceEntity.class);
        listQuery.setSourceTableName("Tables");
        if (!Utility.isNullOrEmpty(prefix)) {
            String prefixFilter = String.format("(%s ge '%s') and (%s lt '%s{')", "TableName", prefix, "TableName", prefix);
            listQuery = listQuery.where(prefixFilter);
        }
        return listQuery;
    }

    protected <T extends TableEntity, R> ResultSegment<?> executeQuerySegmentedImpl(TableQuery<T> queryToExecute, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.TABLE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, queryToExecute, this.executeQuerySegmentedWithResolverCoreImpl(queryToExecute, resolver, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private <T extends TableEntity, R> StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<T>> executeQuerySegmentedCoreImpl(final TableQuery<T> queryToExecute, EntityResolver<R> resolver, final TableRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        if (resolver == null) {
            Utility.assertNotNull("Query requires a valid class type or resolver.", queryToExecute.getClazzType());
        }
        options.assertPolicyIfRequired();
        if (options.getEncryptionPolicy() != null) {
            CloudTableClient.addEncryptionProperties(queryToExecute);
        }
        StorageRequest getRequest = new StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<T>>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, TableQuery<T> queryRef, OperationContext context) throws Exception {
                return TableRequest.query(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, queryToExecute.generateQueryBuilder(), context, queryToExecute.getSourceTableName(), null, segmentedRequest.getToken());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<T> preProcessResponse(TableQuery<T> queryRef, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    throw TableServiceException.generateTableServiceException(this.getResult(), null, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                return null;
            }

            @Override
            public ResultSegment<T> postProcessResponse(HttpURLConnection connection, TableQuery<T> queryRef, CloudTableClient client, OperationContext context, ResultSegment<T> storageObject) throws Exception {
                ODataPayload<?> clazzResponse = null;
                InputStream inStream = connection.getInputStream();
                clazzResponse = TableDeserializer.parseQueryResponse(inStream, options, queryToExecute.getClazzType(), null, context);
                ResultContinuation nextToken = TableResponse.getTableContinuationFromResponse(connection);
                if (nextToken != null) {
                    nextToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                segmentedRequest.setToken(nextToken);
                return new ResultSegment(clazzResponse.results, queryToExecute.getTakeCount() == null ? clazzResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
            }

            @Override
            public StorageExtendedErrorInformation parseErrorDetails() {
                return TableStorageErrorDeserializer.parseErrorDetails(this);
            }
        };
        return getRequest;
    }

    private <T extends TableEntity, R> StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<R>> executeQuerySegmentedWithResolverCoreImpl(final TableQuery<T> queryToExecute, final EntityResolver<R> resolver, final TableRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        if (resolver == null) {
            Utility.assertNotNull("Query requires a valid class type or resolver.", queryToExecute.getClazzType());
        }
        if (options.getEncryptionPolicy() != null) {
            CloudTableClient.addEncryptionProperties(queryToExecute);
        }
        StorageRequest getRequest = new StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<R>>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, TableQuery<T> queryRef, OperationContext context) throws Exception {
                return TableRequest.query(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, queryToExecute.generateQueryBuilder(), context, queryToExecute.getSourceTableName(), null, segmentedRequest.getToken());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<R> preProcessResponse(TableQuery<T> queryRef, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    throw TableServiceException.generateTableServiceException(this.getResult(), null, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                return null;
            }

            @Override
            public ResultSegment<R> postProcessResponse(HttpURLConnection connection, TableQuery<T> queryRef, CloudTableClient client, OperationContext context, ResultSegment<R> storageObject) throws Exception {
                ODataPayload<?> resolvedResponse = null;
                InputStream inStream = connection.getInputStream();
                resolvedResponse = TableDeserializer.parseQueryResponse(inStream, options, queryToExecute.getClazzType(), resolver, context);
                ResultContinuation nextToken = TableResponse.getTableContinuationFromResponse(connection);
                if (nextToken != null) {
                    nextToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                segmentedRequest.setToken(nextToken);
                return new ResultSegment(resolvedResponse.results, queryToExecute.getTakeCount() == null ? resolvedResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
            }

            @Override
            public StorageExtendedErrorInformation parseErrorDetails() {
                return TableStorageErrorDeserializer.parseErrorDetails(this);
            }
        };
        return getRequest;
    }

    private static void addEncryptionProperties(TableQuery<?> queryToExecute) {
        String[] columns;
        if (queryToExecute.getColumns() != null) {
            columns = new String[queryToExecute.getColumns().length + 2];
            System.arraycopy(queryToExecute.getColumns(), 0, columns, 2, queryToExecute.getColumns().length);
        } else {
            columns = new String[]{"_ClientEncryptionMetadata1", "_ClientEncryptionMetadata2"};
        }
        queryToExecute.setColumns(columns);
    }

    protected final StorageUri getTransformedEndPoint(OperationContext opContext) throws URISyntaxException, StorageException {
        return this.getCredentials().transformUri(this.getStorageUri(), opContext);
    }

    protected <T extends TableEntity, R> Iterable<?> generateIteratorForQuery(TableQuery<T> queryRef, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        if (resolver == null) {
            return new LazySegmentedIterable<CloudTableClient, TableQuery<T>, T>(this.executeQuerySegmentedCoreImpl(queryRef, resolver, options, segmentedRequest), this, queryRef, options.getRetryPolicyFactory(), opContext);
        }
        return new LazySegmentedIterable<CloudTableClient, TableQuery<T>, R>(this.executeQuerySegmentedWithResolverCoreImpl(queryRef, resolver, options, segmentedRequest), this, queryRef, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, true), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, true), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (!Utility.isNullOrEmpty(properties.getDefaultServiceVersion())) {
            throw new IllegalArgumentException("DefaultServiceVersion can only be set for the Blob service.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, true), options.getRetryPolicyFactory(), opContext);
    }

    @Override
    public TableRequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public void setDefaultRequestOptions(TableRequestOptions defaultRequestOptions) {
        Utility.assertNotNull("defaultRequestOptions", defaultRequestOptions);
        this.defaultRequestOptions = defaultRequestOptions;
    }

    @Override
    protected boolean isUsePathStyleUris() {
        return super.isUsePathStyleUris();
    }
}

