/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.Credentials;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageKey;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Utility;
import java.net.URI;

public final class StorageCredentialsAccountAndKey
extends StorageCredentials {
    private Credentials credentials;

    public StorageCredentialsAccountAndKey(String accountName, byte[] key) {
        this.credentials = new Credentials(accountName, key);
    }

    public StorageCredentialsAccountAndKey(String accountName, String key) {
        this.credentials = new Credentials(accountName, key);
    }

    @Override
    public String getAccountName() {
        return this.credentials.getAccountName();
    }

    public String exportBase64EncodedKey() {
        return this.credentials.getKey().getBase64EncodedKey();
    }

    public byte[] exportKey() {
        return this.credentials.getKey().getKey();
    }

    public void setAccountName(String accountName) {
        this.credentials.setAccountName(accountName);
    }

    public void updateKey(String key) {
        if (Utility.isNullOrEmptyOrWhitespace(key) || !Base64.validateIsBase64String(key)) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.credentials.setKey(new StorageKey(Base64.decode(key)));
    }

    public void updateKey(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.credentials.setKey(new StorageKey(key));
    }

    @Deprecated
    public String getAccountKeyName() {
        return this.credentials.getKeyName();
    }

    @Deprecated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Deprecated
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s;%s=%s", "AccountName", this.getAccountName(), "AccountKey", exportSecrets ? this.credentials.getKey().getBase64EncodedKey() : "[key hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) {
        return resourceUri;
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) {
        return resourceUri;
    }
}

