/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.analytics.CloudAnalyticsClient;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import com.microsoft.azure.storage.table.CloudTableClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CloudStorageAccount {
    protected static final String ACCOUNT_KEY_NAME = "AccountKey";
    protected static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String DNS_NAME_FORMAT = "%s.%s";
    private static final String DEFAULT_DNS = "core.windows.net";
    private static final String SECONDARY_LOCATION_ACCOUNT_SUFFIX = "-secondary";
    private static final String ENDPOINT_SUFFIX_NAME = "EndpointSuffix";
    protected static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
    private static final String DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT = "%s://%s:%s/%s";
    private static final String DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT = "%s://%s:%s/%s-secondary";
    private static final String DEVELOPMENT_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
    private static final String DEVSTORE_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String DEVSTORE_ACCOUNT_NAME = "devstoreaccount1";
    private static final String FILE_ENDPOINT_NAME = "FileEndpoint";
    private static final String PRIMARY_ENDPOINT_FORMAT = "%s://%s.%s";
    private static final String SECONDARY_ENDPOINT_FORMAT = "%s://%s%s.%s";
    protected static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
    protected static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
    protected static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
    private static final String USE_DEVELOPMENT_STORAGE_NAME = "UseDevelopmentStorage";
    private String endpointSuffix;
    private final StorageUri blobStorageUri;
    private final StorageUri fileStorageUri;
    private final StorageUri queueStorageUri;
    private final StorageUri tableStorageUri;
    private StorageCredentials credentials;
    private boolean isBlobEndpointDefault = false;
    private boolean isFileEndpointDefault = false;
    private boolean isQueueEndpointDefault = false;
    private boolean isTableEndpointDefault = false;
    private boolean isDevStoreAccount = false;

    public static CloudStorageAccount getDevelopmentStorageAccount() {
        try {
            return CloudStorageAccount.getDevelopmentStorageAccount(null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static CloudStorageAccount getDevelopmentStorageAccount(URI proxyUri) throws URISyntaxException {
        String host;
        String scheme;
        if (proxyUri == null) {
            scheme = "http";
            host = "127.0.0.1";
        } else {
            scheme = proxyUri.getScheme();
            host = proxyUri.getHost();
        }
        StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(DEVSTORE_ACCOUNT_NAME, DEVSTORE_ACCOUNT_KEY);
        URI blobPrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queuePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tablePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        URI blobSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queueSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tableSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        CloudStorageAccount account = new CloudStorageAccount((StorageCredentials)credentials, new StorageUri(blobPrimaryEndpoint, blobSecondaryEndpoint), new StorageUri(queuePrimaryEndpoint, queueSecondaryEndpoint), new StorageUri(tablePrimaryEndpoint, tableSecondaryEndpoint), null);
        account.isDevStoreAccount = true;
        return account;
    }

    public static CloudStorageAccount parse(String connectionString) throws URISyntaxException, InvalidKeyException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Invalid connection string.");
        }
        HashMap<String, String> settings = Utility.parseAccountString(connectionString);
        for (Map.Entry entry : settings.entrySet()) {
            if (entry.getValue() != null && !((String)entry.getValue()).equals("") || ((String)entry.getKey()).equals(ACCOUNT_KEY_NAME)) continue;
            throw new IllegalArgumentException("Invalid connection string.");
        }
        CloudStorageAccount account = CloudStorageAccount.tryConfigureDevStore(settings);
        if (account != null) {
            return account;
        }
        account = CloudStorageAccount.tryConfigureServiceAccount(settings);
        if (account != null) {
            return account;
        }
        throw new IllegalArgumentException("Invalid connection string.");
    }

    private static StorageUri getStorageUri(Map<String, String> settings, String service, String serviceEndpoint) throws URISyntaxException {
        if (settings.containsKey(serviceEndpoint)) {
            return new StorageUri(new URI(settings.get(serviceEndpoint)));
        }
        if (settings.containsKey(DEFAULT_ENDPOINTS_PROTOCOL_NAME) && settings.containsKey(ACCOUNT_NAME_NAME) && settings.containsKey(ACCOUNT_KEY_NAME)) {
            String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME);
            String accountName = settings.get(ACCOUNT_NAME_NAME);
            String endpointSuffix = settings.get(ENDPOINT_SUFFIX_NAME);
            return CloudStorageAccount.getDefaultStorageUri(scheme, accountName, CloudStorageAccount.getDNS(service, endpointSuffix));
        }
        return null;
    }

    private static StorageUri getDefaultStorageUri(String scheme, String accountName, String service) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        URI primaryUri = new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, service));
        URI secondaryUri = new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, service));
        return new StorageUri(primaryUri, secondaryUri);
    }

    private static String getDNS(String service, String base) {
        if (base == null) {
            base = DEFAULT_DNS;
        }
        return String.format(DNS_NAME_FORMAT, service, base);
    }

    private static CloudStorageAccount tryConfigureDevStore(Map<String, String> settings) throws URISyntaxException {
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            if (!Boolean.parseBoolean(settings.get(USE_DEVELOPMENT_STORAGE_NAME))) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            URI devStoreProxyUri = null;
            if (settings.containsKey(DEVELOPMENT_STORAGE_PROXY_URI_NAME)) {
                devStoreProxyUri = new URI(settings.get(DEVELOPMENT_STORAGE_PROXY_URI_NAME));
            }
            return CloudStorageAccount.getDevelopmentStorageAccount(devStoreProxyUri);
        }
        return null;
    }

    private static CloudStorageAccount tryConfigureServiceAccount(Map<String, String> settings) throws URISyntaxException, InvalidKeyException {
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            if (!Boolean.parseBoolean(settings.get(USE_DEVELOPMENT_STORAGE_NAME))) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            return null;
        }
        String defaultEndpointSetting = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME);
        if (defaultEndpointSetting != null && !(defaultEndpointSetting = defaultEndpointSetting.toLowerCase()).equals("http") && !defaultEndpointSetting.equals("https")) {
            return null;
        }
        StorageCredentials credentials = StorageCredentials.tryParseCredentials(settings);
        CloudStorageAccount account = new CloudStorageAccount(credentials, CloudStorageAccount.getStorageUri(settings, "blob", BLOB_ENDPOINT_NAME), CloudStorageAccount.getStorageUri(settings, "queue", QUEUE_ENDPOINT_NAME), CloudStorageAccount.getStorageUri(settings, "table", TABLE_ENDPOINT_NAME), CloudStorageAccount.getStorageUri(settings, "file", FILE_ENDPOINT_NAME));
        if (account.getBlobEndpoint() == null && account.getFileEndpoint() == null && account.getQueueEndpoint() == null && account.getTableEndpoint() == null) {
            return null;
        }
        account.isBlobEndpointDefault = account.getBlobEndpoint() != null && !settings.containsKey(BLOB_ENDPOINT_NAME);
        account.isFileEndpointDefault = account.getFileEndpoint() != null && !settings.containsKey(FILE_ENDPOINT_NAME);
        account.isQueueEndpointDefault = account.getQueueEndpoint() != null && !settings.containsKey(QUEUE_ENDPOINT_NAME);
        account.isTableEndpointDefault = account.getTableEndpoint() != null && !settings.containsKey(TABLE_ENDPOINT_NAME);
        account.endpointSuffix = settings.get(ENDPOINT_SUFFIX_NAME);
        return account;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials) throws URISyntaxException {
        this(storageCredentials, false, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, boolean useHttps) throws URISyntaxException {
        this(storageCredentials, useHttps, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, boolean useHttps, String endpointSuffix) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        String protocol = useHttps ? "https" : "http";
        this.credentials = storageCredentials;
        this.blobStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, storageCredentials.getAccountName(), CloudStorageAccount.getDNS("blob", endpointSuffix));
        this.fileStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, storageCredentials.getAccountName(), CloudStorageAccount.getDNS("file", endpointSuffix));
        this.queueStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, storageCredentials.getAccountName(), CloudStorageAccount.getDNS("queue", endpointSuffix));
        this.tableStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, storageCredentials.getAccountName(), CloudStorageAccount.getDNS("table", endpointSuffix));
        this.endpointSuffix = endpointSuffix;
        this.isBlobEndpointDefault = true;
        this.isFileEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint, URI fileEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), new StorageUri(fileEndpoint));
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri) {
        this(storageCredentials, blobStorageUri, queueStorageUri, tableStorageUri, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri, StorageUri fileStorageUri) {
        this.credentials = storageCredentials;
        this.blobStorageUri = blobStorageUri;
        this.fileStorageUri = fileStorageUri;
        this.queueStorageUri = queueStorageUri;
        this.tableStorageUri = tableStorageUri;
        this.endpointSuffix = null;
    }

    public CloudAnalyticsClient createCloudAnalyticsClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        return new CloudAnalyticsClient(this.getBlobStorageUri(), this.getTableStorageUri(), this.getCredentials());
    }

    public CloudBlobClient createCloudBlobClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudBlobClient(this.getBlobStorageUri(), this.getCredentials());
    }

    public CloudFileClient createCloudFileClient() {
        if (this.getFileStorageUri() == null) {
            throw new IllegalArgumentException("No file endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudFileClient(this.getFileStorageUri(), this.getCredentials());
    }

    public CloudQueueClient createCloudQueueClient() {
        if (this.getQueueStorageUri() == null) {
            throw new IllegalArgumentException("No queue endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudQueueClient(this.getQueueStorageUri(), this.getCredentials());
    }

    public CloudTableClient createCloudTableClient() {
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudTableClient(this.getTableStorageUri(), this.getCredentials());
    }

    public URI getBlobEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.blobStorageUri == null) {
            return null;
        }
        return this.blobStorageUri.getPrimaryUri();
    }

    public StorageUri getBlobStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.blobStorageUri;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public URI getFileEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.fileStorageUri == null) {
            return null;
        }
        return this.fileStorageUri.getPrimaryUri();
    }

    public StorageUri getFileStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.fileStorageUri;
    }

    public URI getQueueEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.queueStorageUri == null) {
            return null;
        }
        return this.queueStorageUri.getPrimaryUri();
    }

    public StorageUri getQueueStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.queueStorageUri;
    }

    public URI getTableEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.tableStorageUri == null) {
            return null;
        }
        return this.tableStorageUri.getPrimaryUri();
    }

    public StorageUri getTableStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.tableStorageUri;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean exportSecrets) {
        if (this.credentials != null && Utility.isNullOrEmpty(this.credentials.getAccountName())) {
            return this.credentials.toString(exportSecrets);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (this.isDevStoreAccount) {
            values.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
            if (!this.getBlobEndpoint().toString().equals("http://127.0.0.1:10000/devstoreaccount1")) {
                values.add(String.format("%s=%s://%s/", DEVELOPMENT_STORAGE_PROXY_URI_NAME, this.getBlobEndpoint().getScheme(), this.getBlobEndpoint().getHost()));
            }
        } else {
            String attributeFormat = "%s=%s";
            boolean addDefault = false;
            if (this.endpointSuffix != null) {
                values.add(String.format("%s=%s", ENDPOINT_SUFFIX_NAME, this.endpointSuffix));
            }
            if (this.getBlobStorageUri() != null) {
                if (this.isBlobEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", BLOB_ENDPOINT_NAME, this.getBlobEndpoint()));
                }
            }
            if (this.getQueueStorageUri() != null) {
                if (this.isQueueEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", QUEUE_ENDPOINT_NAME, this.getQueueEndpoint()));
                }
            }
            if (this.getTableStorageUri() != null) {
                if (this.isTableEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", TABLE_ENDPOINT_NAME, this.getTableEndpoint()));
                }
            }
            if (this.getFileStorageUri() != null) {
                if (this.isFileEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", FILE_ENDPOINT_NAME, this.getFileEndpoint()));
                }
            }
            if (addDefault) {
                values.add(String.format("%s=%s", DEFAULT_ENDPOINTS_PROTOCOL_NAME, this.getBlobEndpoint().getScheme()));
            }
            if (this.getCredentials() != null) {
                values.add(this.getCredentials().toString(exportSecrets));
            }
        }
        StringBuilder returnString = new StringBuilder();
        for (String val : values) {
            returnString.append(val);
            returnString.append(';');
        }
        if (values.size() > 0) {
            returnString.deleteCharAt(returnString.length() - 1);
        }
        return returnString.toString();
    }

    protected void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }
}

