/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.core.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class StorageKey {
    private Mac hmacSha256;
    private Mac hmacSha512;
    private SecretKey key256;
    private SecretKey key512;
    private byte[] key;

    public static synchronized String computeMacSha256(StorageKey storageKey, String stringToSign) throws InvalidKeyException {
        if (storageKey.hmacSha256 == null) {
            storageKey.initHmacSha256();
        }
        byte[] utf8Bytes = null;
        try {
            utf8Bytes = stringToSign.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.encode(storageKey.hmacSha256.doFinal(utf8Bytes));
    }

    public static synchronized String computeMacSha512(StorageKey storageKey, String stringToSign) throws InvalidKeyException {
        if (storageKey.hmacSha512 == null) {
            storageKey.initHmacSha512();
        }
        byte[] utf8Bytes = null;
        try {
            utf8Bytes = stringToSign.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.encode(storageKey.hmacSha512.doFinal(utf8Bytes));
    }

    public StorageKey(byte[] key) {
        this.setKey(key);
    }

    public String getBase64EncodedKey() {
        return Base64.encode(this.key);
    }

    public byte[] getKey() {
        byte[] copy = (byte[])this.key.clone();
        return copy;
    }

    private void initHmacSha256() throws InvalidKeyException {
        this.key256 = new SecretKeySpec(this.key, "HmacSHA256");
        try {
            this.hmacSha256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException();
        }
        this.hmacSha256.init(this.key256);
    }

    private void initHmacSha512() throws InvalidKeyException {
        this.key512 = new SecretKeySpec(this.key, "HmacSHA512");
        try {
            this.hmacSha512 = Mac.getInstance("HmacSHA512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException();
        }
        this.hmacSha512.init(this.key512);
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.hmacSha256 = null;
        this.hmacSha512 = null;
        this.key256 = null;
        this.key512 = null;
    }

    public void setKey(String key) {
        this.key = Base64.decode(key);
    }
}

