/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.IProgressReceiver;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;

public class TransferManagerUploadToBlockBlobOptions {
    public static final TransferManagerUploadToBlockBlobOptions DEFAULT = new TransferManagerUploadToBlockBlobOptions(null, null, null, null, null);
    private final IProgressReceiver progressReceiver;
    private final BlobHTTPHeaders httpHeaders;
    private final Metadata metadata;
    private final BlobAccessConditions accessConditions;
    private final int parallelism;

    public TransferManagerUploadToBlockBlobOptions(IProgressReceiver progressReceiver, BlobHTTPHeaders httpHeaders, Metadata metadata, BlobAccessConditions accessConditions, Integer parallelism) {
        this.progressReceiver = progressReceiver;
        if (parallelism == null) {
            this.parallelism = 5;
        } else {
            if (parallelism <= 0) {
                throw new IllegalArgumentException("Parallelism must be > 0");
            }
            this.parallelism = parallelism;
        }
        this.httpHeaders = httpHeaders;
        this.metadata = metadata;
        this.accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
    }

    public IProgressReceiver progressReceiver() {
        return this.progressReceiver;
    }

    public BlobHTTPHeaders httpHeaders() {
        return this.httpHeaders;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public BlobAccessConditions accessConditions() {
        return this.accessConditions;
    }

    public int parallelism() {
        return this.parallelism;
    }
}

