/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.rest.v2.http.UrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class BlobURLParts {
    private String scheme;
    private String host;
    private String containerName;
    private String blobName;
    private String snapshot;
    private SASQueryParameters sasQueryParameters;
    private Map<String, String[]> unparsedParameters = new HashMap<String, String[]>();

    public String scheme() {
        return this.scheme;
    }

    public BlobURLParts withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String host() {
        return this.host;
    }

    public BlobURLParts withHost(String host) {
        this.host = host;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public BlobURLParts withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String blobName() {
        return this.blobName;
    }

    public BlobURLParts withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public BlobURLParts withSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public SASQueryParameters sasQueryParameters() {
        return this.sasQueryParameters;
    }

    public BlobURLParts withSasQueryParameters(SASQueryParameters sasQueryParameters) {
        this.sasQueryParameters = sasQueryParameters;
        return this;
    }

    public Map<String, String[]> unparsedParameters() {
        return this.unparsedParameters;
    }

    public BlobURLParts withUnparsedParameters(Map<String, String[]> unparsedParameters) {
        this.unparsedParameters = unparsedParameters;
        return this;
    }

    public URL toURL() throws MalformedURLException {
        String encodedSAS;
        UrlBuilder url = new UrlBuilder().withScheme(this.scheme).withHost(this.host);
        StringBuilder path = new StringBuilder();
        if (this.containerName != null) {
            path.append(this.containerName);
            if (this.blobName != null) {
                path.append('/');
                path.append(this.blobName);
            }
        }
        url.withPath(path.toString());
        if (this.snapshot != null) {
            url.setQueryParameter("snapshot", this.snapshot);
        }
        if (this.sasQueryParameters != null && (encodedSAS = this.sasQueryParameters.encode()).length() != 0) {
            url.withQuery(encodedSAS);
        }
        for (Map.Entry<String, String[]> entry : this.unparsedParameters.entrySet()) {
            url.setQueryParameter(entry.getKey(), Utility.safeURLEncode(String.join((CharSequence)",", entry.getValue())));
        }
        return url.toURL();
    }
}

