/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.b2c;

import com.microsoft.azure.spring.autoconfigure.b2c.AADB2CConfigurationException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.util.Assert;

public class AADB2CURL {
    private static final String AUTHORIZATION_URL_PATTERN = "https://%s.b2clogin.com/%s.onmicrosoft.com/oauth2/v2.0/authorize";
    private static final String TOKEN_URL_PATTERN = "https://%s.b2clogin.com/%s.onmicrosoft.com/oauth2/v2.0/token?p=%s";
    private static final String JWKSET_URL_PATTERN = "https://%s.b2clogin.com/%s.onmicrosoft.com/discovery/v2.0/keys?p=%s";
    private static final String END_SESSION_URL_PATTERN = "https://%s.b2clogin.com/%s.onmicrosoft.com/oauth2/v2.0/logout?post_logout_redirect_uri=%s&p=%s";

    public static String getAuthorizationUrl(String tenant) {
        Assert.hasText((String)tenant, (String)"tenant should have text.");
        return String.format(AUTHORIZATION_URL_PATTERN, tenant, tenant);
    }

    public static String getTokenUrl(String tenant, String userFlow) {
        Assert.hasText((String)tenant, (String)"tenant should have text.");
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return String.format(TOKEN_URL_PATTERN, tenant, tenant, userFlow);
    }

    public static String getJwkSetUrl(String tenant, String userFlow) {
        Assert.hasText((String)tenant, (String)"tenant should have text.");
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return String.format(JWKSET_URL_PATTERN, tenant, tenant, userFlow);
    }

    public static String getEndSessionUrl(String tenant, String logoutUrl, String userFlow) {
        Assert.hasText((String)tenant, (String)"tenant should have text.");
        Assert.hasText((String)logoutUrl, (String)"logoutUrl should have text.");
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return String.format(END_SESSION_URL_PATTERN, tenant, tenant, AADB2CURL.getEncodedURL(logoutUrl), userFlow);
    }

    private static String getEncodedURL(String url) {
        Assert.hasText((String)url, (String)"url should have text.");
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AADB2CConfigurationException("failed to encode url: " + url, e);
        }
    }

    private AADB2CURL() {
    }
}

