/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.microsoft.azure.keyvault.spring.Constants;
import com.microsoft.azure.keyvault.spring.KeyVaultOperation;
import com.microsoft.azure.keyvault.spring.KeyVaultPropertySource;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class KeyVaultEnvironmentPostProcessorHelper {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultEnvironmentPostProcessorHelper.class);
    private final ConfigurableEnvironment environment;

    public KeyVaultEnvironmentPostProcessorHelper(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.sendTelemetry();
    }

    public void addKeyVaultPropertySource(String normalizedName) {
        String vaultUri = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "uri");
        Long refreshInterval = Optional.ofNullable(this.environment.getProperty("azure.keyvault." + normalizedName + "refresh-interval")).map(Long::valueOf).orElse(1800000L);
        Binder binder = Binder.get((Environment)this.environment);
        List secretKeys = (List)binder.bind("azure.keyvault." + normalizedName + "secret.keys", Bindable.listOf(String.class)).orElse(Collections.emptyList());
        TokenCredential tokenCredential = this.getCredentials(normalizedName);
        SecretClient secretClient = new SecretClientBuilder().vaultUrl(vaultUri).credential(tokenCredential).httpLogOptions(new HttpLogOptions().setApplicationId(Constants.SPRINGBOOT_KEY_VAULT_APPLICATION_ID)).buildClient();
        try {
            MutablePropertySources sources = this.environment.getPropertySources();
            KeyVaultOperation kvOperation = new KeyVaultOperation(secretClient, vaultUri, refreshInterval, secretKeys);
            if (normalizedName.equals("")) {
                if (sources.contains("systemEnvironment")) {
                    sources.addAfter("systemEnvironment", (PropertySource)new KeyVaultPropertySource(kvOperation));
                } else {
                    sources.addFirst((PropertySource)new KeyVaultPropertySource(kvOperation));
                }
            } else if (sources.contains("systemEnvironment")) {
                sources.addAfter("systemEnvironment", (PropertySource)new KeyVaultPropertySource(normalizedName, kvOperation));
            } else {
                sources.addFirst((PropertySource)new KeyVaultPropertySource(normalizedName, kvOperation));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to configure KeyVault property source", ex);
        }
    }

    public TokenCredential getCredentials() {
        return this.getCredentials("");
    }

    public TokenCredential getCredentials(String normalizedName) {
        if (this.environment.containsProperty("azure.keyvault." + normalizedName + "client-id") && this.environment.containsProperty("azure.keyvault." + normalizedName + "client-key") && this.environment.containsProperty("azure.keyvault." + normalizedName + "tenant-id")) {
            log.debug("Will use custom credentials");
            String clientId = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "client-id");
            String clientKey = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "client-key");
            String tenantId = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "tenant-id");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(clientKey).tenantId(tenantId)).build();
            return clientSecretCredential;
        }
        if (this.environment.containsProperty("azure.keyvault." + normalizedName + "client-id") && this.environment.containsProperty("azure.keyvault." + normalizedName + "certificate.path") && this.environment.containsProperty("azure.keyvault." + normalizedName + "tenant-id")) {
            String certPwd = this.environment.getProperty("azure.keyvault." + normalizedName + "certificate.password");
            String certPath = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "certificate.path");
            if (StringUtils.isEmpty((Object)certPwd)) {
                return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(this.getProperty(this.environment, "azure.keyvault." + normalizedName + "tenant-id"))).clientId(this.getProperty(this.environment, "azure.keyvault." + normalizedName + "client-id"))).pemCertificate(certPath).build();
            }
            return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(this.getProperty(this.environment, "azure.keyvault." + normalizedName + "tenant-id"))).clientId(this.getProperty(this.environment, "azure.keyvault." + normalizedName + "client-id"))).pfxCertificate(certPath, certPwd).build();
        }
        if (this.environment.containsProperty("azure.keyvault." + normalizedName + "client-id")) {
            log.debug("Will use MSI credentials with specified clientId");
            String clientId = this.getProperty(this.environment, "azure.keyvault." + normalizedName + "client-id");
            return new ManagedIdentityCredentialBuilder().clientId(clientId).build();
        }
        log.debug("Will use MSI credentials");
        return new ManagedIdentityCredentialBuilder().build();
    }

    private String getProperty(ConfigurableEnvironment env, String propertyName) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        Assert.notNull((Object)propertyName, (String)"propertyName must not be null!");
        String property = env.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property " + propertyName + " must not be null");
        }
        return property;
    }

    private boolean allowTelemetry(ConfigurableEnvironment env) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        return (Boolean)env.getProperty("azure.keyvault.allow.telemetry", Boolean.class, (Object)true);
    }

    private void sendTelemetry() {
        if (this.allowTelemetry(this.environment)) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(KeyVaultEnvironmentPostProcessorHelper.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

