/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud;

import com.azure.core.management.Region;
import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.springcloud.AbstractMojoBase;
import com.microsoft.azure.maven.springcloud.config.AppDeploymentRawConfig;
import com.microsoft.azure.maven.springcloud.config.AppRawConfig;
import com.microsoft.azure.maven.springcloud.config.ClusterRawConfig;
import com.microsoft.azure.maven.springcloud.config.ConfigurationPrompter;
import com.microsoft.azure.maven.springcloud.config.ConfigurationUpdater;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import com.microsoft.azure.toolkit.lib.springcloud.model.Sku;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.atteo.evo.inflector.English;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="config", requiresDirectInvocation=true, aggregator=true)
public class ConfigMojo
extends AbstractMojoBase {
    private static final Logger log;
    private static final String DEPLOYMENT_TAG = "deployment";
    private static final List<String> APP_PROPERTIES;
    private static final List<String> DEPLOYMENT_PROPERTIES;
    private static final String JAVA_8 = "Java 8";
    private static final String JAVA_11 = "Java 11";
    private static final String JAVA_17 = "Java 17";
    private static final Map<String, Integer> JAVA_RUNTIMES;
    private Boolean parentMode;
    private ConfigurationPrompter wrapper;
    private List<MavenProject> targetProjects = new ArrayList<MavenProject>();
    private List<MavenProject> publicProjects;
    private Map<MavenProject, String> appNameByProject;
    private AppRawConfig appSettings;
    private ClusterRawConfig clusterSettings;
    private AppDeploymentRawConfig deploymentSettings;
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution mojoExecution;
    @Parameter(property="advancedOptions")
    private Boolean advancedOptions;
    private boolean useExistingCluster = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(value="user/springcloud.config_mojo")
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (!this.settings.isInteractiveMode()) {
                throw new UnsupportedOperationException("The goal 'config' must be run at interactive mode.");
            }
            if (!MavenConfigUtils.isPomPackaging((MavenProject)this.project) && !MavenConfigUtils.isJarPackaging((MavenProject)this.project)) {
                throw new UnsupportedOperationException(String.format("The project (%s) with packaging %s is not supported for Azure Spring Apps.", this.project.getName(), this.project.getPackaging()));
            }
            if (this.isProjectConfigured(this.project)) {
                log.warn(String.format("Project (%s) is already configured and won't be affected by this command.", this.project.getName()));
            } else {
                this.appSettings = new AppRawConfig();
                this.clusterSettings = new ClusterRawConfig();
                this.deploymentSettings = new AppDeploymentRawConfig();
                this.parentMode = MavenConfigUtils.isPomPackaging((MavenProject)this.project);
                if (this.parentMode.booleanValue() && BooleanUtils.isTrue((Boolean)this.advancedOptions)) {
                    throw new UnsupportedOperationException("The \"advancedOptions\" mode is not supported at parent folder.");
                }
                PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
                try {
                    this.wrapper = new ConfigurationPrompter((ExpressionEvaluator)expressionEvaluator);
                    this.wrapper.initialize();
                    this.wrapper.putCommonVariable("project", this.project);
                    this.selectProjects();
                    if (this.targetProjects != null && !this.targetProjects.isEmpty()) {
                        boolean useExistingApp;
                        this.loginAzure();
                        this.promptAndSelectSubscription();
                        SpringCloudClusterModule module = ((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(this.subscriptionId);
                        this.useExistingCluster = CollectionUtils.isNotEmpty((Collection)module.list()) && this.wrapper.handleConfirm("Use existing Azure Spring Apps in Azure (Y/n):", true, true);
                        SpringCloudCluster cluster = this.useExistingCluster ? this.selectAppCluster() : this.configCluster();
                        boolean bl = useExistingApp = Objects.nonNull(cluster) && this.parentMode == false && this.wrapper.handleConfirm(String.format("Use existing app in Azure Spring Apps %s (y/N):", cluster.getName()), false, true);
                        if (useExistingApp) {
                            this.selectApp(cluster);
                        } else {
                            this.configCommon();
                        }
                        this.confirmAndSave();
                    }
                }
                catch (MavenDecryptException | AzureToolkitAuthenticationException | InvalidConfigurationException | IOException | UnsupportedOperationException e) {
                    throw new AzureExecutionException(e.getMessage());
                }
                finally {
                    if (this.wrapper != null) {
                        try {
                            this.wrapper.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private SpringCloudCluster configCluster() throws IOException, InvalidConfigurationException {
        this.configureClusterName();
        this.configureResourceGroup();
        Sku sku = this.configureSku();
        this.configureRegion(sku);
        return null;
    }

    private void configureClusterName() throws IOException, InvalidConfigurationException {
        String cluster = this.wrapper.handle("configure-cluster-name", false);
        this.clusterSettings.setClusterName(cluster);
        this.wrapper.putCommonVariable("cluster", cluster);
    }

    private void configureResourceGroup() throws IOException, InvalidConfigurationException {
        String resourceGroup = this.wrapper.handle("configure-resource-group-name", false);
        this.clusterSettings.setResourceGroup(resourceGroup);
    }

    private Region configureRegion(@Nonnull Sku sku) throws IOException, InvalidConfigurationException {
        List regions = ((SpringCloudServiceSubscription)((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).forSubscription(this.getSubscriptionId())).listSupportedRegions(sku);
        assert (CollectionUtils.isNotEmpty((Collection)regions)) : String.format("No valid region found for sku %s.", sku.toString());
        this.wrapper.putCommonVariable("regions", regions);
        Region defaultRegion = regions.contains(Region.US_EAST) ? Region.US_EAST : (Region)regions.get(0);
        Region result = this.autoUseDefault() ? defaultRegion : this.wrapper.handleSelectOne("configure-region", regions, defaultRegion, Region::name);
        this.clusterSettings.setRegion(result.name());
        return result;
    }

    private Sku configureSku() throws IOException, InvalidConfigurationException {
        List rawSkus = ((SpringCloudServiceSubscription)((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).forSubscription(this.getSubscriptionId())).listSupportedSkus(null);
        List skus = rawSkus.stream().filter(sku -> !sku.isConsumptionTier()).collect(Collectors.toList());
        assert (CollectionUtils.isNotEmpty(skus)) : "No valid sku found in current subscription.";
        this.wrapper.putCommonVariable("skus", skus);
        Sku defaultSku = skus.contains(Sku.SPRING_APPS_DEFAULT_SKU) ? Sku.SPRING_APPS_DEFAULT_SKU : (Sku)skus.get(0);
        Sku result = this.wrapper.handleSelectOne("configure-sku", skus, defaultSku, Sku::toString);
        this.clusterSettings.setSku(result.toString());
        return result;
    }

    private void configureEnvironment() throws IOException, InvalidConfigurationException {
        Object defaultEnvironment;
        List environments = ((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(this.getSubscriptionId()).list();
        if (CollectionUtils.isEmpty((Collection)environments)) {
            defaultEnvironment = String.format("cae-%s", this.clusterSettings.getClusterName());
            this.clusterSettings.setEnvironment((String)defaultEnvironment);
            log.info(String.format("No environment found, will create new app environment %s.", defaultEnvironment));
        }
        this.wrapper.putCommonVariable("environments", environments);
        defaultEnvironment = (ContainerAppsEnvironment)environments.get(0);
        Object containerAppsEnvironment = this.autoUseDefault() ? defaultEnvironment : this.wrapper.handleSelectOne("configure-environment", environments, defaultEnvironment, AbstractAzResource::getName);
        this.clusterSettings.setEnvironment(containerAppsEnvironment.getName());
        this.clusterSettings.setEnvironmentResourceGroup(containerAppsEnvironment.getResourceGroupName());
    }

    private void configCommon() throws IOException, InvalidConfigurationException {
        this.configureAppName();
        if (this.notEnterpriseTier()) {
            this.configureJavaVersion();
        }
        this.configurePublic();
        this.configDeployment();
    }

    private void configDeployment() throws IOException, InvalidConfigurationException {
        this.configureInstanceCount();
        this.configureCpu();
        this.configureMemory();
        this.configureJvmOptions();
    }

    private boolean notEnterpriseTier() {
        return !Sku.fromString((String)this.clusterSettings.getSku()).isEnterpriseTier();
    }

    private void selectProjects() throws IOException, InvalidConfigurationException {
        if (this.parentMode.booleanValue()) {
            List allProjects = this.session.getAllProjects().stream().filter(MavenConfigUtils::isJarPackaging).collect(Collectors.toList());
            ArrayList<MavenProject> configuredProjects = new ArrayList<MavenProject>();
            for (MavenProject proj : allProjects) {
                if (this.isProjectConfigured(proj)) {
                    configuredProjects.add(proj);
                    continue;
                }
                this.targetProjects.add(proj);
            }
            this.wrapper.putCommonVariable("projects", this.targetProjects);
            if (!configuredProjects.isEmpty()) {
                log.warn(String.format("The following child %s %s already configured: ", English.plural((String)"module", (int)configuredProjects.size()), configuredProjects.size() > 1 ? "are" : "is"));
                for (MavenProject proj : configuredProjects) {
                    System.out.println("    " + TextUtils.yellow((String)proj.getName()));
                }
            } else if (this.targetProjects.isEmpty()) {
                log.warn("There are no projects in current folder with package 'jar'.");
                return;
            }
            this.targetProjects = this.wrapper.handleMultipleCase("select-projects", this.targetProjects, MavenProject::getName);
        } else {
            this.targetProjects.add(this.project);
        }
        this.wrapper.putCommonVariable("projects", this.targetProjects);
    }

    private void configureJavaVersion() throws IOException, InvalidConfigurationException {
        List validRuntimes = this.getValidRuntimes(new ArrayList<String>(JAVA_RUNTIMES.keySet()), JAVA_RUNTIMES::get);
        assert (CollectionUtils.isNotEmpty((Collection)validRuntimes)) : "No valid runtime found for current project.";
        this.wrapper.putCommonVariable("runtimes", validRuntimes);
        String defaultRuntime = validRuntimes.contains(JAVA_11) ? JAVA_11 : (String)validRuntimes.get(0);
        this.deploymentSettings.setRuntimeVersion(this.wrapper.handleSelectOne("configure-java-version", validRuntimes, defaultRuntime, t -> t));
    }

    private void configureJvmOptions() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setJvmOptions(this.wrapper.handle("configure-jvm-options", this.autoUseDefault()));
    }

    private void configureCpu() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setCpu(this.wrapper.handle("configure-cpu", this.autoUseDefault()));
    }

    private void configureMemory() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setMemoryInGB(this.wrapper.handle("configure-memory", this.autoUseDefault()));
    }

    private void configureInstanceCount() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setInstanceCount(this.wrapper.handle("configure-instance-count", this.autoUseDefault()));
    }

    private boolean autoUseDefault() {
        return !BooleanUtils.isTrue((Boolean)this.advancedOptions) || this.parentMode != false;
    }

    private void confirmAndSave() throws IOException {
        LinkedHashMap<String, String> changesToConfirm = new LinkedHashMap<String, String>();
        changesToConfirm.put("Subscription id", this.subscriptionId);
        changesToConfirm.put("Resource group name", this.clusterSettings.getResourceGroup());
        changesToConfirm.put("Azure Spring Apps name", this.clusterSettings.getClusterName());
        if (this.notEnterpriseTier()) {
            changesToConfirm.put("Runtime Java version", this.deploymentSettings.getRuntimeVersion());
        }
        if (!this.useExistingCluster) {
            changesToConfirm.put("Region", this.clusterSettings.getRegion());
            changesToConfirm.put("Sku", this.clusterSettings.getSku());
            if (StringUtils.equalsIgnoreCase((CharSequence)"StandardGen2", (CharSequence)this.clusterSettings.getSku())) {
                changesToConfirm.put("Environment", this.clusterSettings.getEnvironment());
                changesToConfirm.put("Environment resource group", this.clusterSettings.getEnvironmentResourceGroup());
            }
        }
        if (this.parentMode.booleanValue()) {
            changesToConfirm.put("App " + English.plural((String)"name", (int)this.appNameByProject.size()), String.join((CharSequence)",", this.appNameByProject.values()));
            if (this.publicProjects != null && this.publicProjects.size() > 0) {
                changesToConfirm.put("Public " + English.plural((String)"app", (int)this.publicProjects.size()), this.publicProjects.stream().map(p -> this.appNameByProject.get(p)).collect(Collectors.joining(",")));
            }
            this.wrapper.confirmChanges(changesToConfirm, this::saveConfigurationToPom);
        } else {
            changesToConfirm.put("App name", this.appSettings.getAppName());
            changesToConfirm.put("Public access", this.appSettings.getIsPublic());
            changesToConfirm.put("Instance count/max replicas", this.deploymentSettings.getInstanceCount());
            changesToConfirm.put("CPU count", this.deploymentSettings.getCpu());
            changesToConfirm.put("Memory size(GB)", this.deploymentSettings.getMemoryInGB());
            changesToConfirm.put("JVM options", this.deploymentSettings.getJvmOptions());
            this.wrapper.confirmChanges(changesToConfirm, this::saveConfigurationToPom);
        }
    }

    private Integer saveConfigurationToPom() {
        this.telemetries.put("isPomFileModified", String.valueOf(true));
        this.clusterSettings.setSubscriptionId(this.subscriptionId);
        for (MavenProject proj : this.targetProjects) {
            if (this.parentMode.booleanValue()) {
                this.appSettings.setAppName(this.appNameByProject.get(proj));
                this.appSettings.setIsPublic(this.publicProjects != null && this.publicProjects.contains(proj) ? "true" : "false");
            }
            this.saveConfigurationToProject(proj);
        }
        if (this.parentMode.booleanValue()) {
            ConfigurationUpdater.updateAppConfigToPom(null, this.project, this.plugin);
        }
        return this.targetProjects.size();
    }

    private void saveConfigurationToProject(MavenProject proj) throws DocumentException, IOException {
        this.appSettings.setDeployment(this.deploymentSettings);
        this.appSettings.setCluster(this.clusterSettings);
        ConfigurationUpdater.updateAppConfigToPom(this.appSettings, proj, this.plugin);
    }

    private void configurePublic() throws IOException, InvalidConfigurationException {
        if (this.parentMode.booleanValue()) {
            this.publicProjects = this.wrapper.handleMultipleCase("configure-public-list", this.targetProjects, MavenProject::getName);
        } else {
            this.appSettings.setIsPublic(this.wrapper.handle("configure-public", false));
        }
    }

    private void configureAppName() throws IOException, InvalidConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)this.appName) && this.parentMode.booleanValue()) {
            throw new UnsupportedOperationException("Cannot specify appName in parent mode.");
        }
        if (this.parentMode.booleanValue()) {
            this.appNameByProject = new HashMap<MavenProject, String>();
            for (MavenProject proj : this.targetProjects) {
                this.wrapper.putCommonVariable("project", proj);
                this.appNameByProject.put(proj, this.wrapper.handle("configure-app-name", this.parentMode, this.appName));
            }
            this.wrapper.putCommonVariable("project", this.project);
            String duplicateAppNames = this.appNameByProject.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(t -> (Long)t.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)duplicateAppNames)) {
                throw new InvalidConfigurationException(String.format("Cannot apply default appName due to duplicate: %s", duplicateAppNames));
            }
        } else {
            this.appSettings.setAppName(this.wrapper.handle("configure-app-name", false, this.appName));
        }
    }

    private SpringCloudApp selectApp(@Nonnull SpringCloudCluster cluster) throws IOException, InvalidConfigurationException {
        log.info(String.format("It may take a few minutes to list apps in your Azure Spring Apps %s, please be patient.", cluster.getName()));
        if (StringUtils.isNotBlank((CharSequence)this.appName)) {
            SpringCloudApp springCloudApp = (SpringCloudApp)cluster.apps().get(this.appName, this.resourceGroup);
            if (Objects.nonNull(springCloudApp) && springCloudApp.exists()) {
                this.appSettings.saveSpringCloudApp(springCloudApp);
            }
            log.warn(String.format("Cannot find app with name: %s in Azure Spring Apps: %s.", TextUtils.yellow((String)this.appName), TextUtils.yellow((String)cluster.getName())));
        }
        List apps = cluster.apps().list();
        this.wrapper.putCommonVariable("apps", apps);
        SpringCloudApp targetApp = this.wrapper.handleSelectOne("select-App", apps, null, AbstractAzResource::getName);
        this.appSettings.saveSpringCloudApp(targetApp);
        this.saveDeployment(targetApp);
        return targetApp;
    }

    private void saveDeployment(SpringCloudApp targetApp) throws IOException, InvalidConfigurationException {
        SpringCloudDeployment activeDeployment = Optional.ofNullable(targetApp.getActiveDeployment()).orElseGet(() -> targetApp.deployments().list().stream().findFirst().orElse(null));
        if (Objects.nonNull(activeDeployment)) {
            this.deploymentSettings.saveSpringCloudDeployment(activeDeployment);
        } else {
            this.configCommon();
        }
    }

    private SpringCloudCluster selectAppCluster() throws IOException, InvalidConfigurationException {
        log.info("It may take a few minutes to list Azure Spring Apps in your account, please be patient.");
        SpringCloudClusterModule az = ((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(this.subscriptionId);
        if (StringUtils.isNotBlank((CharSequence)this.clusterName)) {
            SpringCloudCluster cluster = az.get(this.clusterName, this.resourceGroup);
            if (Objects.nonNull(cluster) && cluster.exists()) {
                this.clusterSettings.setResourceGroup(cluster.getResourceGroupName());
                this.clusterSettings.setClusterName(cluster.getName());
                return cluster;
            }
            log.warn(String.format("Cannot find Azure Spring Apps with name: %s in resource group: %s.", TextUtils.yellow((String)this.clusterName), TextUtils.yellow((String)this.resourceGroup)));
        }
        List clusters = az.list();
        this.wrapper.putCommonVariable("clusters", clusters);
        SpringCloudCluster targetAppCluster = this.wrapper.handleSelectOne("select-ASC", clusters, null, AbstractAzResource::getName);
        if (targetAppCluster != null) {
            this.clusterSettings.setResourceGroup(targetAppCluster.getResourceGroupName());
            this.clusterSettings.setClusterName(targetAppCluster.getName());
            this.clusterSettings.setSku(targetAppCluster.getSku().toString());
            log.info(String.format("Using Azure Spring Apps: %s", TextUtils.blue((String)targetAppCluster.getName())));
        }
        return targetAppCluster;
    }

    protected void promptAndSelectSubscription() {
        if (StringUtils.isBlank((CharSequence)this.subscriptionId)) {
            List subscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSubscriptions();
            this.subscriptionId = CollectionUtils.isNotEmpty((Collection)subscriptions) && subscriptions.size() == 1 ? ((Subscription)subscriptions.get(0)).getId() : this.promptSubscription();
        }
        this.selectSubscription();
    }

    private String promptSubscription() throws IOException, InvalidConfigurationException {
        List subscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSubscriptions();
        List selectedSubscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSelectedSubscriptions();
        this.wrapper.putCommonVariable("subscriptions", subscriptions);
        Subscription select = this.wrapper.handleSelectOne("select-subscriptions", subscriptions, CollectionUtils.isNotEmpty((Collection)selectedSubscriptions) ? (Subscription)selectedSubscriptions.get(0) : null, t -> String.format("%s (%s)", t.getName(), t.getId()));
        ((AzureAccount)Azure.az(AzureAccount.class)).account().setSelectedSubscriptions(Collections.singletonList(select.getId()));
        return select.getId();
    }

    private boolean isProjectConfigured(MavenProject proj) {
        String pluginIdentifier = this.plugin.getPluginLookupKey();
        Xpp3Dom configuration = MavenConfigUtils.getPluginConfiguration((MavenProject)proj, (String)pluginIdentifier);
        if (configuration == null) {
            return false;
        }
        for (Xpp3Dom child : configuration.getChildren()) {
            if (!APP_PROPERTIES.contains(child.getName())) continue;
            return true;
        }
        if (configuration.getChild(DEPLOYMENT_TAG) != null) {
            for (Xpp3Dom child : configuration.getChild(DEPLOYMENT_TAG).getChildren()) {
                if (!DEPLOYMENT_PROPERTIES.contains(child.getName())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ConfigMojo.ajc$preClinit();
        log = LoggerFactory.getLogger(ConfigMojo.class);
        APP_PROPERTIES = Arrays.asList("appName", "isPublic");
        DEPLOYMENT_PROPERTIES = Arrays.asList("cpu", "memoryInGB", "instanceCount", "jvmOptions", "runtimeVersion");
        JAVA_RUNTIMES = new LinkedHashMap<String, Integer>(){
            {
                this.put(ConfigMojo.JAVA_8, 8);
                this.put(ConfigMojo.JAVA_11, 11);
                this.put(ConfigMojo.JAVA_17, 17);
            }
        };
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigMojo.java", ConfigMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.springcloud.ConfigMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 138);
    }
}

