/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.TransactionContext;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.CoreMessageSender;
import com.microsoft.azure.servicebus.primitives.ExceptionUtil;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.SenderLinkSettings;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.Util;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Controller {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(Controller.class);
    private MessagingFactory messagingFactory;
    private CoreMessageSender internalSender;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private URI namespaceEndpointURI;
    private ClientSettings clientSettings;

    Controller(URI namespaceEndpointURI, MessagingFactory factory, ClientSettings clientSettings) {
        this.namespaceEndpointURI = namespaceEndpointURI;
        this.messagingFactory = factory;
        this.clientSettings = clientSettings;
    }

    synchronized CompletableFuture<Void> initializeAsync() {
        if (this.isInitialized.get()) {
            return CompletableFuture.completedFuture(null);
        }
        TRACE_LOGGER.info("Creating MessageSender to coordinator");
        CompletableFuture<CoreMessageSender> senderFuture = CoreMessageSender.create(this.messagingFactory, StringUtil.getShortRandomString(), null, Controller.getControllerLinkSettings(this.messagingFactory));
        CompletableFuture<Void> postSenderCreationFuture = new CompletableFuture<Void>();
        senderFuture.handleAsync((s, coreSenderCreationEx) -> {
            if (coreSenderCreationEx == null) {
                this.internalSender = s;
                this.isInitialized.set(true);
                TRACE_LOGGER.info("Created MessageSender to coordinator");
                postSenderCreationFuture.complete(null);
            } else {
                Throwable cause = ExceptionUtil.extractAsyncCompletionCause(coreSenderCreationEx);
                TRACE_LOGGER.info("Creating MessageSender to coordinator failed", cause);
                this.messagingFactory.closeAsync();
                postSenderCreationFuture.completeExceptionally(cause);
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return postSenderCreationFuture;
    }

    public CompletableFuture<Binary> declareAsync() {
        Message message = Message.Factory.create();
        Declare declare = new Declare();
        message.setBody((Section)new AmqpValue((Object)declare));
        return this.internalSender.sendAndReturnDeliveryStateAsync(message, TransactionContext.NULL_TXN).thenApply(state -> {
            Binary txnId = null;
            if (state instanceof Declared) {
                Declared declared = (Declared)state;
                txnId = declared.getTxnId();
                TRACE_LOGGER.debug("New TX started: {}", (Object)txnId);
            } else {
                CompletableFuture exceptionFuture = new CompletableFuture();
                exceptionFuture.completeExceptionally(new UnsupportedOperationException("Received unknown state: " + state.toString()));
            }
            return txnId;
        });
    }

    public CompletableFuture<Void> dischargeAsync(Binary txnId, boolean isCommit) {
        Message message = Message.Factory.create();
        Discharge discharge = new Discharge();
        discharge.setFail(Boolean.valueOf(!isCommit));
        discharge.setTxnId(txnId);
        message.setBody((Section)new AmqpValue((Object)discharge));
        return this.internalSender.sendAndReturnDeliveryStateAsync(message, TransactionContext.NULL_TXN).thenCompose(state -> {
            if (state instanceof Accepted) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture returnTask = new CompletableFuture();
            returnTask.completeExceptionally(new UnsupportedOperationException("Received unknown state: " + state.toString()));
            return returnTask;
        });
    }

    protected CompletableFuture<Void> closeAsync() {
        return null;
    }

    private static SenderLinkSettings getControllerLinkSettings(MessagingFactory underlyingFactory) {
        SenderLinkSettings linkSettings = new SenderLinkSettings();
        linkSettings.linkPath = "coordinator";
        Coordinator target = new Coordinator();
        linkSettings.target = target;
        linkSettings.source = new Source();
        linkSettings.settleMode = SenderSettleMode.UNSETTLED;
        linkSettings.requiresAuthentication = false;
        HashMap<Symbol, Object> linkProperties = new HashMap<Symbol, Object>();
        linkProperties.put(ClientConstants.LINK_TIMEOUT_PROPERTY, UnsignedInteger.valueOf((long)Util.adjustServerTimeout(underlyingFactory.getOperationTimeout()).toMillis()));
        linkSettings.linkProperties = linkProperties;
        return linkSettings;
    }
}

