/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.AuthorizationRuleSerializer;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.management.TopicDescription;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class TopicDescriptionSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(TopicDescriptionSerializer.class);

    TopicDescriptionSerializer() {
    }

    static String serialize(TopicDescription topicDescription) throws ServiceBusException {
        DocumentBuilder dBuilder;
        try {
            DocumentBuilderFactory dbFactory = SerializerUtil.getDocumentBuilderFactory();
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        doc.appendChild(rootElement);
        Element contentElement = doc.createElementNS("http://www.w3.org/2005/Atom", "content");
        rootElement.appendChild(contentElement);
        contentElement.setAttribute("type", "application/xml");
        Element tdElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
        contentElement.appendChild(tdElement);
        if (topicDescription.defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive").appendChild(doc.createTextNode(topicDescription.defaultMessageTimeToLive.toString())).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes").appendChild(doc.createTextNode(Long.toString(topicDescription.maxSizeInMB))).getParentNode());
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection").appendChild(doc.createTextNode(Boolean.toString(topicDescription.requiresDuplicateDetection))).getParentNode());
        if (topicDescription.requiresDuplicateDetection && topicDescription.duplicationDetectionHistoryTimeWindow.compareTo(Duration.ZERO) > 0) {
            tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow").appendChild(doc.createTextNode(topicDescription.duplicationDetectionHistoryTimeWindow.toString())).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enableBatchedOperations))).getParentNode());
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing").appendChild(doc.createTextNode(Boolean.toString(topicDescription.filterMessagesBeforePublishing))).getParentNode());
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible").appendChild(doc.createTextNode(Boolean.toString(topicDescription.isAnonymousAccessible))).getParentNode());
        if (topicDescription.authorizationRules != null) {
            tdElement.appendChild(AuthorizationRuleSerializer.serializeRules(topicDescription.authorizationRules, doc));
        }
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status").appendChild(doc.createTextNode(topicDescription.status.name())).getParentNode());
        if (topicDescription.forwardTo != null) {
            tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ForwardTo").appendChild(doc.createTextNode(topicDescription.forwardTo)).getParentNode());
        }
        if (topicDescription.userMetadata != null) {
            tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UserMetadata").appendChild(doc.createTextNode(topicDescription.userMetadata)).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering").appendChild(doc.createTextNode(Boolean.toString(topicDescription.supportOrdering))).getParentNode());
        if (topicDescription.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle").appendChild(doc.createTextNode(topicDescription.autoDeleteOnIdle.toString())).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnablePartitioning").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enablePartitioning))).getParentNode());
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableSubscriptionPartitioning").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enableSubscriptionPartitioning))).getParentNode());
        tdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableExpress").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enableExpress))).getParentNode());
        topicDescription.appendUnknownPropertiesToDescriptionElement(tdElement);
        StringWriter output = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        return output.toString();
    }

    static List<TopicDescription> parseCollectionFromContent(String xml) {
        ArrayList<TopicDescription> topicList;
        block4: {
            topicList = new ArrayList<TopicDescription>();
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("entry")) continue;
                    topicList.add(TopicDescriptionSerializer.parseFromEntry(node));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        return topicList;
    }

    static TopicDescription parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if ("entry".equals(doc.getTagName())) {
                    return TopicDescriptionSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Topic was not found");
    }

    private static TopicDescription parseFromEntry(Node xEntry) {
        TopicDescription td = null;
        NodeList nList = xEntry.getChildNodes();
        block54: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    td = new TopicDescription(element.getFirstChild().getNodeValue());
                    continue block54;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block55: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "DefaultMessageTimeToLive": {
                                td.defaultMessageTimeToLive = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "MaxSizeInMegabytes": {
                                td.maxSizeInMB = Long.parseLong(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "RequiresDuplicateDetection": {
                                td.requiresDuplicateDetection = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "DuplicateDetectionHistoryTimeWindow": {
                                td.duplicationDetectionHistoryTimeWindow = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "EnableBatchedOperations": {
                                td.enableBatchedOperations = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "FilteringMessagesBeforePublishing": {
                                td.filterMessagesBeforePublishing = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "IsAnonymousAccessible": {
                                td.isAnonymousAccessible = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "AuthorizationRules": {
                                td.authorizationRules = AuthorizationRuleSerializer.parseAuthRules(element);
                                continue block55;
                            }
                            case "Status": {
                                td.status = EntityStatus.valueOf(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "ForwardTo": {
                                Node fwd = element.getFirstChild();
                                if (fwd == null) continue block55;
                                td.forwardTo = fwd.getNodeValue();
                                continue block55;
                            }
                            case "UserMetadata": {
                                td.userMetadata = element.getFirstChild().getNodeValue();
                                continue block55;
                            }
                            case "SupportOrdering": {
                                td.supportOrdering = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "AutoDeleteOnIdle": {
                                td.autoDeleteOnIdle = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "EnablePartitioning": {
                                td.enablePartitioning = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "EnableSubscriptionPartitioning": {
                                td.enableSubscriptionPartitioning = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "EnableExpress": {
                                td.enableExpress = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block55;
                            }
                            case "AccessedAt": 
                            case "CreatedAt": 
                            case "MessageCount": 
                            case "SizeInBytes": 
                            case "UpdatedAt": 
                            case "CountDetails": 
                            case "SubscriptionCount": 
                            case "EntityAvailabilityStatus": 
                            case "SkippedUpdate": {
                                continue block55;
                            }
                            default: {
                                td.addUnknownProperty(element);
                            }
                        }
                    }
                    continue block54;
                }
            }
        }
        return td;
    }
}

