/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.ProxyConnectionHandler;
import com.microsoft.azure.servicebus.amqp.StrictTLSContext;
import com.microsoft.azure.servicebus.amqp.StrictTLSContextSpi;
import com.microsoft.azure.servicebus.amqp.WebSocketConnectionHandler;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.TransportType;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
extends BaseHandler {
    private static final SslDomain.VerifyMode VERIFY_MODE;
    private static final Logger TRACE_LOGGER;
    protected final IAmqpConnection messagingFactory;

    protected ConnectionHandler(IAmqpConnection messagingFactory) {
        this.add((Handler)new Handshaker());
        this.messagingFactory = messagingFactory;
    }

    public static ConnectionHandler create(TransportType transportType, IAmqpConnection messagingFactory) {
        switch (transportType) {
            case AMQP_WEB_SOCKETS: {
                if (ProxyConnectionHandler.shouldUseProxy(messagingFactory.getHostName())) {
                    return new ProxyConnectionHandler(messagingFactory);
                }
                return new WebSocketConnectionHandler(messagingFactory);
            }
        }
        return new ConnectionHandler(messagingFactory);
    }

    public void onConnectionInit(Event event) {
        Connection connection = event.getConnection();
        String hostName = this.messagingFactory.getHostName() + ":" + String.valueOf(this.getProtocolPort());
        TRACE_LOGGER.debug("onConnectionInit: hostname:{}", (Object)hostName);
        connection.setHostname(hostName);
        connection.setContainer(StringUtil.getShortRandomString());
        HashMap<Symbol, String> connectionProperties = new HashMap<Symbol, String>();
        connectionProperties.put(AmqpConstants.PRODUCT, "MSJavaClient");
        connectionProperties.put(AmqpConstants.VERSION, ClientConstants.CURRENT_JAVACLIENT_VERSION);
        connectionProperties.put(AmqpConstants.PLATFORM, ClientConstants.PLATFORM_INFO);
        connection.setProperties(connectionProperties);
        connection.open();
    }

    protected IAmqpConnection getMessagingFactory() {
        return this.messagingFactory;
    }

    public void addTransportLayers(Event event, TransportInternal transport) {
        SslDomain domain = Proton.sslDomain();
        domain.init(SslDomain.Mode.CLIENT);
        if (VERIFY_MODE == SslDomain.VerifyMode.VERIFY_PEER_NAME) {
            try {
                SSLContext defaultContext = SSLContext.getDefault();
                StrictTLSContextSpi strictTlsContextSpi = new StrictTLSContextSpi(defaultContext);
                StrictTLSContext strictTlsContext = new StrictTLSContext(strictTlsContextSpi, defaultContext.getProvider(), defaultContext.getProtocol());
                domain.setSslContext((SSLContext)strictTlsContext);
                domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER_NAME);
                SslPeerDetails peerDetails = Proton.sslPeerDetails((String)this.messagingFactory.getHostName(), (int)this.getProtocolPort());
                transport.ssl(domain, peerDetails);
            }
            catch (NoSuchAlgorithmException e) {
                TRACE_LOGGER.info("Default SSL algorithm not found in JRE. Please check your JRE setup.", (Throwable)e);
            }
        } else if (VERIFY_MODE == SslDomain.VerifyMode.VERIFY_PEER) {
            try {
                SSLContext defaultContext = SSLContext.getDefault();
                domain.setSslContext(defaultContext);
                domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
                transport.ssl(domain);
            }
            catch (NoSuchAlgorithmException e) {
                TRACE_LOGGER.info("Default SSL algorithm not found in JRE. Please check your JRE setup.", (Throwable)e);
            }
        } else {
            domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
            transport.ssl(domain);
        }
    }

    protected void notifyTransportErrors(Event event) {
    }

    public String getOutboundSocketHostName() {
        return this.messagingFactory.getHostName();
    }

    public int getOutboundSocketPort() {
        return this.getProtocolPort();
    }

    public int getProtocolPort() {
        return 5671;
    }

    public int getMaxFrameSize() {
        return 65536;
    }

    public void onConnectionBound(Event event) {
        TRACE_LOGGER.debug("onConnectionBound: hostname:{}", (Object)event.getConnection().getHostname());
        Transport transport = event.getTransport();
        this.addTransportLayers(event, (TransportInternal)transport);
        Sasl sasl = transport.sasl();
        sasl.setMechanisms(new String[]{"ANONYMOUS"});
    }

    public void onTransportError(Event event) {
        ErrorCondition condition = event.getTransport().getCondition();
        if (condition != null) {
            TRACE_LOGGER.info("Connection.onTransportError: hostname:{}, error:{}", (Object)event.getConnection().getHostname(), (Object)condition.getDescription());
        } else {
            TRACE_LOGGER.info("Connection.onTransportError: hostname:{}. error:{}", (Object)event.getConnection().getHostname(), (Object)"no description returned");
        }
        this.messagingFactory.onConnectionError(condition);
        Connection connection = event.getConnection();
        if (connection != null) {
            connection.free();
        }
        this.notifyTransportErrors(event);
    }

    public void onConnectionRemoteOpen(Event event) {
        TRACE_LOGGER.debug("Connection.onConnectionRemoteOpen: hostname:{}, remotecontainer:{}", (Object)event.getConnection().getHostname(), (Object)event.getConnection().getRemoteContainer());
        this.messagingFactory.onConnectionOpen();
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        TRACE_LOGGER.debug("onConnectionRemoteClose: hostname:{},errorCondition:{}", (Object)connection.getHostname(), error != null ? error.getCondition() + "," + error.getDescription() : null);
        boolean shouldFreeConnection = connection.getLocalState() == EndpointState.CLOSED;
        this.messagingFactory.onConnectionError(error);
        if (shouldFreeConnection) {
            connection.free();
        }
    }

    public void onConnectionFinal(Event event) {
        TRACE_LOGGER.debug("onConnectionFinal: hostname:{}", (Object)event.getConnection().getHostname());
    }

    public void onConnectionLocalClose(Event event) {
        Connection connection = event.getConnection();
        TRACE_LOGGER.debug("onConnectionLocalClose: hostname:{}", (Object)connection.getHostname());
        if (connection.getRemoteState() == EndpointState.CLOSED) {
            if (connection.getTransport() != null) {
                connection.getTransport().unbind();
            }
            connection.free();
        }
    }

    static {
        TRACE_LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
        String verifyModePropValue = System.getProperty("com.microsoft.azure.servicebus.ssl.verifymode");
        VERIFY_MODE = "anonymous".equalsIgnoreCase(verifyModePropValue) ? SslDomain.VerifyMode.ANONYMOUS_PEER : ("verifyCertificateOnly".equalsIgnoreCase(verifyModePropValue) ? SslDomain.VerifyMode.VERIFY_PEER : SslDomain.VerifyMode.VERIFY_PEER_NAME);
    }
}

