/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.IAmqpLink;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLinkHandler
extends BaseHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(BaseLinkHandler.class);
    private final IAmqpLink underlyingEntity;

    public BaseLinkHandler(IAmqpLink amqpLink) {
        this.underlyingEntity = amqpLink;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        if (link != null) {
            TRACE_LOGGER.debug("local link close. linkName:{}", (Object)link.getName());
            BaseLinkHandler.checkAndFreeLink(link);
            BaseLinkHandler.closeSession(link);
        }
    }

    public void onLinkRemoteClose(Event event) {
        Link link = event.getLink();
        if (link != null) {
            TRACE_LOGGER.debug("link remote close. linkName:{}", (Object)link.getName());
            if (link.getLocalState() != EndpointState.CLOSED) {
                link.close();
            }
            ErrorCondition condition = link.getRemoteCondition();
            this.processOnClose(link, condition);
            BaseLinkHandler.checkAndFreeLink(link);
            BaseLinkHandler.closeSession(link);
        }
    }

    public void onLinkRemoteDetach(Event event) {
        Link link = event.getLink();
        if (link != null) {
            TRACE_LOGGER.debug("link remote detach. linkName:{}", (Object)link.getName());
            if (link.getLocalState() != EndpointState.CLOSED) {
                link.close();
            }
            this.processOnClose(link, link.getRemoteCondition());
            BaseLinkHandler.closeSession(link);
        }
    }

    public void onLinkFinal(Event event) {
        Link link = event.getLink();
        if (link != null) {
            link.attachments().clear();
        }
    }

    public void processOnClose(Link link, ErrorCondition condition) {
        if (condition != null) {
            TRACE_LOGGER.debug("linkName:{}, ErrorCondition:{}, {}", new Object[]{link.getName(), condition.getCondition(), condition.getDescription()});
        }
        this.underlyingEntity.onClose(condition);
    }

    public void processOnClose(Link link, Exception exception) {
        this.underlyingEntity.onError(exception);
    }

    private static void closeSession(Link link) {
        if (link.getSession() != null && link.getSession().getLocalState() != EndpointState.CLOSED) {
            link.getSession().close();
        }
    }

    private static void checkAndFreeLink(Link link) {
        if (link.getLocalState() == EndpointState.CLOSED && link.getRemoteState() == EndpointState.CLOSED) {
            link.free();
        }
    }
}

