/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.MessageBody;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

final class Utils {
    Utils() {
    }

    static <T> T completeFuture(CompletableFuture<T> future) throws InterruptedException, ServiceBusException {
        try {
            return future.get();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ServiceBusException) {
                throw (ServiceBusException)cause;
            }
            throw new ServiceBusException(true, cause);
        }
    }

    static void assertNonNull(String argumentName, Object argument) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + argumentName + "' is null.");
        }
    }

    static MessageBody fromSequence(List<Object> sequence) {
        ArrayList<List<Object>> sequenceData = new ArrayList<List<Object>>();
        sequenceData.add(sequence);
        return MessageBody.fromSequenceData(sequenceData);
    }

    static MessageBody fromBinay(byte[] binary) {
        ArrayList<byte[]> binaryData = new ArrayList<byte[]>();
        binaryData.add(binary);
        return MessageBody.fromBinaryData(binaryData);
    }

    static byte[] getDataFromMessageBody(MessageBody messageBody) {
        List<byte[]> binaryData = messageBody.getBinaryData();
        if (binaryData == null || binaryData.size() == 0) {
            return null;
        }
        return binaryData.get(0);
    }

    static List<Object> getSequenceFromMessageBody(MessageBody messageBody) {
        List<List<Object>> sequenceData = messageBody.getSequenceData();
        if (sequenceData == null || sequenceData.size() == 0) {
            return null;
        }
        return sequenceData.get(0);
    }
}

