/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.MessageBodyType;
import java.util.List;

public class MessageBody {
    private MessageBodyType bodyType;
    private Object valueData;
    private List<List<Object>> sequenceData;
    private List<byte[]> binaryData;

    private MessageBody() {
    }

    public static MessageBody fromValueData(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value data is null.");
        }
        MessageBody body = new MessageBody();
        body.bodyType = MessageBodyType.VALUE;
        body.valueData = value;
        body.sequenceData = null;
        body.binaryData = null;
        return body;
    }

    public static MessageBody fromSequenceData(List<List<Object>> sequenceData) {
        if (sequenceData == null || sequenceData.size() == 0 || sequenceData.size() > 1) {
            throw new IllegalArgumentException("Sequence data is null or has more than one collection in it.");
        }
        MessageBody body = new MessageBody();
        body.bodyType = MessageBodyType.SEQUENCE;
        body.valueData = null;
        body.sequenceData = sequenceData;
        body.binaryData = null;
        return body;
    }

    public static MessageBody fromBinaryData(List<byte[]> binaryData) {
        if (binaryData == null || binaryData.size() == 0 || binaryData.size() > 1) {
            throw new IllegalArgumentException("Binary data is null or has more than one byte array in it.");
        }
        MessageBody body = new MessageBody();
        body.bodyType = MessageBodyType.BINARY;
        body.valueData = null;
        body.sequenceData = null;
        body.binaryData = binaryData;
        return body;
    }

    public Object getValueData() {
        return this.valueData;
    }

    public List<List<Object>> getSequenceData() {
        return this.sequenceData;
    }

    public List<byte[]> getBinaryData() {
        return this.binaryData;
    }

    public MessageBodyType getBodyType() {
        return this.bodyType;
    }
}

