/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in TrafficManagerUserMetricsKeys.
 */
public class TrafficManagerUserMetricsKeysInner {
    /** The Retrofit service to perform REST calls. */
    private TrafficManagerUserMetricsKeysService service;
    /** The service client containing this operation class. */
    private TrafficManagerManagementClientImpl client;

    /**
     * Initializes an instance of TrafficManagerUserMetricsKeysInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public TrafficManagerUserMetricsKeysInner(Retrofit retrofit, TrafficManagerManagementClientImpl client) {
        this.service = retrofit.create(TrafficManagerUserMetricsKeysService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for TrafficManagerUserMetricsKeys to be
     * used by Retrofit to perform actually REST calls.
     */
    interface TrafficManagerUserMetricsKeysService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys get" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserMetricsModelInner object if successful.
     */
    public UserMetricsModelInner get() {
        return getWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserMetricsModelInner> getAsync(final ServiceCallback<UserMetricsModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserMetricsModelInner object
     */
    public Observable<UserMetricsModelInner> getAsync() {
        return getWithServiceResponseAsync().map(new Func1<ServiceResponse<UserMetricsModelInner>, UserMetricsModelInner>() {
            @Override
            public UserMetricsModelInner call(ServiceResponse<UserMetricsModelInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserMetricsModelInner object
     */
    public Observable<ServiceResponse<UserMetricsModelInner>> getWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserMetricsModelInner>>>() {
                @Override
                public Observable<ServiceResponse<UserMetricsModelInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserMetricsModelInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserMetricsModelInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UserMetricsModelInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<UserMetricsModelInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserMetricsModelInner object if successful.
     */
    public UserMetricsModelInner createOrUpdate() {
        return createOrUpdateWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserMetricsModelInner> createOrUpdateAsync(final ServiceCallback<UserMetricsModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserMetricsModelInner object
     */
    public Observable<UserMetricsModelInner> createOrUpdateAsync() {
        return createOrUpdateWithServiceResponseAsync().map(new Func1<ServiceResponse<UserMetricsModelInner>, UserMetricsModelInner>() {
            @Override
            public UserMetricsModelInner call(ServiceResponse<UserMetricsModelInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserMetricsModelInner object
     */
    public Observable<ServiceResponse<UserMetricsModelInner>> createOrUpdateWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.createOrUpdate(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserMetricsModelInner>>>() {
                @Override
                public Observable<ServiceResponse<UserMetricsModelInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserMetricsModelInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserMetricsModelInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UserMetricsModelInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<UserMetricsModelInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeleteOperationResultInner object if successful.
     */
    public DeleteOperationResultInner delete() {
        return deleteWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeleteOperationResultInner> deleteAsync(final ServiceCallback<DeleteOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeleteOperationResultInner object
     */
    public Observable<DeleteOperationResultInner> deleteAsync() {
        return deleteWithServiceResponseAsync().map(new Func1<ServiceResponse<DeleteOperationResultInner>, DeleteOperationResultInner>() {
            @Override
            public DeleteOperationResultInner call(ServiceResponse<DeleteOperationResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeleteOperationResultInner object
     */
    public Observable<ServiceResponse<DeleteOperationResultInner>> deleteWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeleteOperationResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeleteOperationResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeleteOperationResultInner> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeleteOperationResultInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeleteOperationResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeleteOperationResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
