/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for TrafficViewEnrollmentStatus.
 */
public final class TrafficViewEnrollmentStatus extends ExpandableStringEnum<TrafficViewEnrollmentStatus> {
    /** Static value Enabled for TrafficViewEnrollmentStatus. */
    public static final TrafficViewEnrollmentStatus ENABLED = fromString("Enabled");

    /** Static value Disabled for TrafficViewEnrollmentStatus. */
    public static final TrafficViewEnrollmentStatus DISABLED = fromString("Disabled");

    /**
     * Creates or finds a TrafficViewEnrollmentStatus from its string representation.
     * @param name a name to look for
     * @return the corresponding TrafficViewEnrollmentStatus
     */
    @JsonCreator
    public static TrafficViewEnrollmentStatus fromString(String name) {
        return fromString(name, TrafficViewEnrollmentStatus.class);
    }

    /**
     * @return known TrafficViewEnrollmentStatus values
     */
    public static Collection<TrafficViewEnrollmentStatus> values() {
        return values(TrafficViewEnrollmentStatus.class);
    }
}
