/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in GeographicHierarchies.
 */
public class GeographicHierarchiesInner {
    /** The Retrofit service to perform REST calls. */
    private GeographicHierarchiesService service;
    /** The service client containing this operation class. */
    private TrafficManagerManagementClientImpl client;

    /**
     * Initializes an instance of GeographicHierarchiesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public GeographicHierarchiesInner(Retrofit retrofit, TrafficManagerManagementClientImpl client) {
        this.service = retrofit.create(GeographicHierarchiesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for GeographicHierarchies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface GeographicHierarchiesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.GeographicHierarchies getRoot" })
        @GET("providers/Microsoft.Network/trafficManagerGeographicHierarchies/default")
        Observable<Response<ResponseBody>> getDefault(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the default Geographic Hierarchy used by the Geographic traffic routing method.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TrafficManagerGeographicHierarchyInner object if successful.
     */
    public TrafficManagerGeographicHierarchyInner getDefault() {
        return getDefaultWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Gets the default Geographic Hierarchy used by the Geographic traffic routing method.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TrafficManagerGeographicHierarchyInner> getDefaultAsync(final ServiceCallback<TrafficManagerGeographicHierarchyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDefaultWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Gets the default Geographic Hierarchy used by the Geographic traffic routing method.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrafficManagerGeographicHierarchyInner object
     */
    public Observable<TrafficManagerGeographicHierarchyInner> getDefaultAsync() {
        return getDefaultWithServiceResponseAsync().map(new Func1<ServiceResponse<TrafficManagerGeographicHierarchyInner>, TrafficManagerGeographicHierarchyInner>() {
            @Override
            public TrafficManagerGeographicHierarchyInner call(ServiceResponse<TrafficManagerGeographicHierarchyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the default Geographic Hierarchy used by the Geographic traffic routing method.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrafficManagerGeographicHierarchyInner object
     */
    public Observable<ServiceResponse<TrafficManagerGeographicHierarchyInner>> getDefaultWithServiceResponseAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDefault(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrafficManagerGeographicHierarchyInner>>>() {
                @Override
                public Observable<ServiceResponse<TrafficManagerGeographicHierarchyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TrafficManagerGeographicHierarchyInner> clientResponse = getDefaultDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TrafficManagerGeographicHierarchyInner> getDefaultDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TrafficManagerGeographicHierarchyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TrafficManagerGeographicHierarchyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
