/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.management.trafficmanager.EndpointStatus;
import com.microsoft.azure.management.trafficmanager.EndpointMonitorStatus;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Class representing a Traffic Manager endpoint.
 */
@JsonFlatten
public class EndpointInner extends ProxyResourceInner {
    /**
     * The Azure Resource URI of the of the endpoint. Not applicable to
     * endpoints of type 'ExternalEndpoints'.
     */
    @JsonProperty(value = "properties.targetResourceId")
    private String targetResourceId;

    /**
     * The fully-qualified DNS name of the endpoint. Traffic Manager returns
     * this value in DNS responses to direct traffic to this endpoint.
     */
    @JsonProperty(value = "properties.target")
    private String target;

    /**
     * The status of the endpoint. If the endpoint is Enabled, it is probed for
     * endpoint health and is included in the traffic routing method. Possible
     * values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.endpointStatus")
    private EndpointStatus endpointStatus;

    /**
     * The weight of this endpoint when using the 'Weighted' traffic routing
     * method. Possible values are from 1 to 1000.
     */
    @JsonProperty(value = "properties.weight")
    private Long weight;

    /**
     * The priority of this endpoint when using the ‘Priority’ traffic routing
     * method. Possible values are from 1 to 1000, lower values represent
     * higher priority. This is an optional parameter.  If specified, it must
     * be specified on all endpoints, and no two endpoints can share the same
     * priority value.
     */
    @JsonProperty(value = "properties.priority")
    private Long priority;

    /**
     * Specifies the location of the external or nested endpoints when using
     * the ‘Performance’ traffic routing method.
     */
    @JsonProperty(value = "properties.endpointLocation")
    private String endpointLocation;

    /**
     * The monitoring status of the endpoint. Possible values include:
     * 'CheckingEndpoint', 'Online', 'Degraded', 'Disabled', 'Inactive',
     * 'Stopped'.
     */
    @JsonProperty(value = "properties.endpointMonitorStatus")
    private EndpointMonitorStatus endpointMonitorStatus;

    /**
     * The minimum number of endpoints that must be available in the child
     * profile in order for the parent profile to be considered available. Only
     * applicable to endpoint of type 'NestedEndpoints'.
     */
    @JsonProperty(value = "properties.minChildEndpoints")
    private Long minChildEndpoints;

    /**
     * The list of countries/regions mapped to this endpoint when using the
     * ‘Geographic’ traffic routing method. Please consult Traffic Manager
     * Geographic documentation for a full list of accepted values.
     */
    @JsonProperty(value = "properties.geoMapping")
    private List<String> geoMapping;

    /**
     * Get the targetResourceId value.
     *
     * @return the targetResourceId value
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId value.
     *
     * @param targetResourceId the targetResourceId value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get the target value.
     *
     * @return the target value
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target value.
     *
     * @param target the target value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the endpointStatus value.
     *
     * @return the endpointStatus value
     */
    public EndpointStatus endpointStatus() {
        return this.endpointStatus;
    }

    /**
     * Set the endpointStatus value.
     *
     * @param endpointStatus the endpointStatus value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointStatus(EndpointStatus endpointStatus) {
        this.endpointStatus = endpointStatus;
        return this;
    }

    /**
     * Get the weight value.
     *
     * @return the weight value
     */
    public Long weight() {
        return this.weight;
    }

    /**
     * Set the weight value.
     *
     * @param weight the weight value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the priority value.
     *
     * @return the priority value
     */
    public Long priority() {
        return this.priority;
    }

    /**
     * Set the priority value.
     *
     * @param priority the priority value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withPriority(Long priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the endpointLocation value.
     *
     * @return the endpointLocation value
     */
    public String endpointLocation() {
        return this.endpointLocation;
    }

    /**
     * Set the endpointLocation value.
     *
     * @param endpointLocation the endpointLocation value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointLocation(String endpointLocation) {
        this.endpointLocation = endpointLocation;
        return this;
    }

    /**
     * Get the endpointMonitorStatus value.
     *
     * @return the endpointMonitorStatus value
     */
    public EndpointMonitorStatus endpointMonitorStatus() {
        return this.endpointMonitorStatus;
    }

    /**
     * Set the endpointMonitorStatus value.
     *
     * @param endpointMonitorStatus the endpointMonitorStatus value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointMonitorStatus(EndpointMonitorStatus endpointMonitorStatus) {
        this.endpointMonitorStatus = endpointMonitorStatus;
        return this;
    }

    /**
     * Get the minChildEndpoints value.
     *
     * @return the minChildEndpoints value
     */
    public Long minChildEndpoints() {
        return this.minChildEndpoints;
    }

    /**
     * Set the minChildEndpoints value.
     *
     * @param minChildEndpoints the minChildEndpoints value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withMinChildEndpoints(Long minChildEndpoints) {
        this.minChildEndpoints = minChildEndpoints;
        return this;
    }

    /**
     * Get the geoMapping value.
     *
     * @return the geoMapping value
     */
    public List<String> geoMapping() {
        return this.geoMapping;
    }

    /**
     * Set the geoMapping value.
     *
     * @param geoMapping the geoMapping value to set
     * @return the EndpointInner object itself.
     */
    public EndpointInner withGeoMapping(List<String> geoMapping) {
        this.geoMapping = geoMapping;
        return this;
    }

}
