/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ProfileStatus.
 */
public final class ProfileStatus {
    /** Static value Enabled for ProfileStatus. */
    public static final ProfileStatus ENABLED = new ProfileStatus("Enabled");

    /** Static value Disabled for ProfileStatus. */
    public static final ProfileStatus DISABLED = new ProfileStatus("Disabled");

    private String value;

    /**
     * Creates a custom value for ProfileStatus.
     * @param value the custom value
     */
    public ProfileStatus(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProfileStatus)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ProfileStatus rhs = (ProfileStatus) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
