/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for EndpointStatus.
 */
public final class EndpointStatus {
    /** Static value Enabled for EndpointStatus. */
    public static final EndpointStatus ENABLED = new EndpointStatus("Enabled");

    /** Static value Disabled for EndpointStatus. */
    public static final EndpointStatus DISABLED = new EndpointStatus("Disabled");

    private String value;

    /**
     * Creates a custom value for EndpointStatus.
     * @param value the custom value
     */
    public EndpointStatus(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointStatus)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        EndpointStatus rhs = (EndpointStatus) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
