/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class representing a Traffic Manager Name Availability response.
 */
public class TrafficManagerNameAvailabilityInner {
    /**
     * The relative name.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Traffic Manager profile resource type.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Describes whether the relative name is available or not.
     */
    @JsonProperty(value = "nameAvailable")
    private Boolean nameAvailable;

    /**
     * The reason why the name is not available, when applicable.
     */
    @JsonProperty(value = "reason")
    private String reason;

    /**
     * Descriptive message that explains why the name is not available, when
     * applicable.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the relative name.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the relative name.
     *
     * @param name the name value to set
     * @return the TrafficManagerNameAvailabilityInner object itself.
     */
    public TrafficManagerNameAvailabilityInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get traffic Manager profile resource type.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set traffic Manager profile resource type.
     *
     * @param type the type value to set
     * @return the TrafficManagerNameAvailabilityInner object itself.
     */
    public TrafficManagerNameAvailabilityInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get describes whether the relative name is available or not.
     *
     * @return the nameAvailable value
     */
    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    /**
     * Set describes whether the relative name is available or not.
     *
     * @param nameAvailable the nameAvailable value to set
     * @return the TrafficManagerNameAvailabilityInner object itself.
     */
    public TrafficManagerNameAvailabilityInner withNameAvailable(Boolean nameAvailable) {
        this.nameAvailable = nameAvailable;
        return this;
    }

    /**
     * Get the reason why the name is not available, when applicable.
     *
     * @return the reason value
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason why the name is not available, when applicable.
     *
     * @param reason the reason value to set
     * @return the TrafficManagerNameAvailabilityInner object itself.
     */
    public TrafficManagerNameAvailabilityInner withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Get descriptive message that explains why the name is not available, when applicable.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set descriptive message that explains why the name is not available, when applicable.
     *
     * @param message the message value to set
     * @return the TrafficManagerNameAvailabilityInner object itself.
     */
    public TrafficManagerNameAvailabilityInner withMessage(String message) {
        this.message = message;
        return this;
    }

}
