/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager.implementation;

import org.joda.time.DateTime;
import java.util.List;
import com.microsoft.azure.management.trafficmanager.HeatMapEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficFlow;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Class representing a Traffic Manager HeatMap.
 */
@JsonFlatten
public class HeatMapModelInner extends ProxyResourceInner {
    /**
     * The beginning of the time window for this HeatMap, inclusive.
     */
    @JsonProperty(value = "properties.startTime")
    private DateTime startTime;

    /**
     * The ending of the time window for this HeatMap, exclusive.
     */
    @JsonProperty(value = "properties.endTime")
    private DateTime endTime;

    /**
     * The endpoints used in this HeatMap calculation.
     */
    @JsonProperty(value = "properties.endpoints")
    private List<HeatMapEndpoint> endpoints;

    /**
     * The traffic flows produced in this HeatMap calculation.
     */
    @JsonProperty(value = "properties.trafficFlows")
    private List<TrafficFlow> trafficFlows;

    /**
     * Get the beginning of the time window for this HeatMap, inclusive.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the beginning of the time window for this HeatMap, inclusive.
     *
     * @param startTime the startTime value to set
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the ending of the time window for this HeatMap, exclusive.
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the ending of the time window for this HeatMap, exclusive.
     *
     * @param endTime the endTime value to set
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the endpoints used in this HeatMap calculation.
     *
     * @return the endpoints value
     */
    public List<HeatMapEndpoint> endpoints() {
        return this.endpoints;
    }

    /**
     * Set the endpoints used in this HeatMap calculation.
     *
     * @param endpoints the endpoints value to set
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withEndpoints(List<HeatMapEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get the traffic flows produced in this HeatMap calculation.
     *
     * @return the trafficFlows value
     */
    public List<TrafficFlow> trafficFlows() {
        return this.trafficFlows;
    }

    /**
     * Set the traffic flows produced in this HeatMap calculation.
     *
     * @param trafficFlows the trafficFlows value to set
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withTrafficFlows(List<TrafficFlow> trafficFlows) {
        this.trafficFlows = trafficFlows;
        return this;
    }

}
