/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.sql.ServerDnsAliasAcquisition;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServerDnsAliases.
 */
public class ServerDnsAliasesInner {
    /** The Retrofit service to perform REST calls. */
    private ServerDnsAliasesService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ServerDnsAliasesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServerDnsAliasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ServerDnsAliasesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServerDnsAliases to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServerDnsAliasesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases listByServer" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases")
        Observable<Response<ResponseBody>> listByServer(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases acquire" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}/acquire")
        Observable<Response<ResponseBody>> acquire(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ServerDnsAliasAcquisition parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginAcquire" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}/acquire")
        Observable<Response<ResponseBody>> beginAcquire(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("dnsAliasName") String dnsAliasName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ServerDnsAliasAcquisition parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases listByServerNext" })
        @GET
        Observable<Response<ResponseBody>> listByServerNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a server DNS alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServerDnsAliasInner object if successful.
     */
    public ServerDnsAliasInner get(String resourceGroupName, String serverName, String dnsAliasName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single().body();
    }

    /**
     * Gets a server DNS alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServerDnsAliasInner> getAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Gets a server DNS alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerDnsAliasInner object
     */
    public Observable<ServerDnsAliasInner> getAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>() {
            @Override
            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a server DNS alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerDnsAliasInner object
     */
    public Observable<ServiceResponse<ServerDnsAliasInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerDnsAliasInner>>>() {
                @Override
                public Observable<ServiceResponse<ServerDnsAliasInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServerDnsAliasInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServerDnsAliasInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServerDnsAliasInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServerDnsAliasInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServerDnsAliasInner object if successful.
     */
    public ServerDnsAliasInner createOrUpdate(String resourceGroupName, String serverName, String dnsAliasName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last().body();
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>() {
            @Override
            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ServerDnsAliasInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerDnsAliasInner>() { }.getType());
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServerDnsAliasInner object if successful.
     */
    public ServerDnsAliasInner beginCreateOrUpdate(String resourceGroupName, String serverName, String dnsAliasName) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single().body();
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerDnsAliasInner object
     */
    public Observable<ServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>() {
            @Override
            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a server dns alias.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerDnsAliasInner object
     */
    public Observable<ServiceResponse<ServerDnsAliasInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerDnsAliasInner>>>() {
                @Override
                public Observable<ServiceResponse<ServerDnsAliasInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServerDnsAliasInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServerDnsAliasInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServerDnsAliasInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServerDnsAliasInner>() { }.getType())
                .register(201, new TypeToken<ServerDnsAliasInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName, String dnsAliasName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last().body();
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serverName, String dnsAliasName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single().body();
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the server DNS alias with the given name.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server DNS alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.beginDelete(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServerDnsAliasInner&gt; object if successful.
     */
    public PagedList<ServerDnsAliasInner> listByServer(final String resourceGroupName, final String serverName) {
        ServiceResponse<Page<ServerDnsAliasInner>> response = listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerDnsAliasInner>(response.body()) {
            @Override
            public Page<ServerDnsAliasInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServerDnsAliasInner>> listByServerAsync(final String resourceGroupName, final String serverName, final ListOperationCallback<ServerDnsAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerSinglePageAsync(resourceGroupName, serverName),
            new Func1<String, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerDnsAliasInner&gt; object
     */
    public Observable<Page<ServerDnsAliasInner>> listByServerAsync(final String resourceGroupName, final String serverName) {
        return listByServerWithServiceResponseAsync(resourceGroupName, serverName)
            .map(new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Page<ServerDnsAliasInner>>() {
                @Override
                public Page<ServerDnsAliasInner> call(ServiceResponse<Page<ServerDnsAliasInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerDnsAliasInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerWithServiceResponseAsync(final String resourceGroupName, final String serverName) {
        return listByServerSinglePageAsync(resourceGroupName, serverName)
            .concatMap(new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(ServiceResponse<Page<ServerDnsAliasInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
    ServiceResponse<PageImpl1<ServerDnsAliasInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<ServerDnsAliasInner>> * @param serverName The name of the server that the alias is pointing to.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServerDnsAliasInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerSinglePageAsync(final String resourceGroupName, final String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServerDnsAliasInner>> result = listByServerDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServerDnsAliasInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServerDnsAliasInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ServerDnsAliasInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ServerDnsAliasInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void acquire(String resourceGroupName, String serverName, String dnsAliasName) {
        acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last().body();
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> acquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final String oldServerDnsAliasId = null;
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(null);
        Observable<Response<ResponseBody>> observable = service.acquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }
    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void acquire(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).toBlocking().last().body();
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId), serviceCallback);
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        return acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> acquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(oldServerDnsAliasId);
        Observable<Response<ResponseBody>> observable = service.acquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginAcquire(String resourceGroupName, String serverName, String dnsAliasName) {
        beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single().body();
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginAcquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final String oldServerDnsAliasId = null;
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(null);
        return service.beginAcquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginAcquireDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginAcquire(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).toBlocking().single().body();
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId), serviceCallback);
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        return beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Acquires server DNS alias from another server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @param dnsAliasName The name of the server dns alias.
     * @param oldServerDnsAliasId The id of the server alias that will be acquired to point to this server instead.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginAcquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(oldServerDnsAliasId);
        return service.beginAcquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginAcquireDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginAcquireDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServerDnsAliasInner&gt; object if successful.
     */
    public PagedList<ServerDnsAliasInner> listByServerNext(final String nextPageLink) {
        ServiceResponse<Page<ServerDnsAliasInner>> response = listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerDnsAliasInner>(response.body()) {
            @Override
            public Page<ServerDnsAliasInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServerDnsAliasInner>> listByServerNextAsync(final String nextPageLink, final ServiceFuture<List<ServerDnsAliasInner>> serviceFuture, final ListOperationCallback<ServerDnsAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerDnsAliasInner&gt; object
     */
    public Observable<Page<ServerDnsAliasInner>> listByServerNextAsync(final String nextPageLink) {
        return listByServerNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Page<ServerDnsAliasInner>>() {
                @Override
                public Page<ServerDnsAliasInner> call(ServiceResponse<Page<ServerDnsAliasInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerDnsAliasInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerNextWithServiceResponseAsync(final String nextPageLink) {
        return listByServerNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(ServiceResponse<Page<ServerDnsAliasInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of server DNS aliases for a server.
     *
    ServiceResponse<PageImpl1<ServerDnsAliasInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServerDnsAliasInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServerDnsAliasInner>> result = listByServerNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServerDnsAliasInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServerDnsAliasInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ServerDnsAliasInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ServerDnsAliasInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
