/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ManagedDatabaseVulnerabilityAssessments.
 */
public class ManagedDatabaseVulnerabilityAssessmentsInner {
    /** The Retrofit service to perform REST calls. */
    private ManagedDatabaseVulnerabilityAssessmentsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ManagedDatabaseVulnerabilityAssessmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ManagedDatabaseVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ManagedDatabaseVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ManagedDatabaseVulnerabilityAssessments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ManagedDatabaseVulnerabilityAssessmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Body DatabaseVulnerabilityAssessmentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments listByDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments")
        Observable<Response<ResponseBody>> listByDatabase(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("databaseName") String databaseName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments listByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseVulnerabilityAssessmentInner object if successful.
     */
    public DatabaseVulnerabilityAssessmentInner get(String resourceGroupName, String managedInstanceName, String databaseName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, final ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    /**
     * Gets the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentInner object
     */
    public Observable<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map(new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>() {
            @Override
            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.get(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseVulnerabilityAssessmentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseVulnerabilityAssessmentInner object if successful.
     */
    public DatabaseVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters, final ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentInner object
     */
    public Observable<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map(new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>() {
            @Override
            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseVulnerabilityAssessmentInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>() { }.getType())
                .register(201, new TypeToken<DatabaseVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Removes the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String managedInstanceName, String databaseName) {
        deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single().body();
    }

    /**
     * Removes the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    /**
     * Removes the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes the database's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.delete(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabase(final String resourceGroupName, final String managedInstanceName, final String databaseName) {
        ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response = listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(final String resourceGroupName, final String managedInstanceName, final String databaseName, final ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(final String resourceGroupName, final String managedInstanceName, final String databaseName) {
        return listByDatabaseWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName)
            .map(new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>() {
                @Override
                public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName, final String databaseName) {
        return listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
    ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> * @param managedInstanceName The name of the managed instance.
    ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseSinglePageAsync(final String resourceGroupName, final String managedInstanceName, final String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.listByDatabase(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> result = listByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DatabaseVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response = listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> serviceFuture, final ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(final String nextPageLink) {
        return listByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>() {
                @Override
                public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessments of a managed database.
     *
    ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DatabaseVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> result = listByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DatabaseVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
